/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.wfclient;

import com.github.charlemaznable.core.codec.Bytes;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.CommonReq;
import com.github.charlemaznable.httpclient.common.FallbackFunction;
import com.github.charlemaznable.httpclient.common.HttpStatus;
import com.github.charlemaznable.httpclient.wfclient.elf.GlobalClientElf;
import io.micrometer.observation.ObservationRegistry;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Mono;

public final class WfReq
extends CommonReq<WfReq> {
    private static final WebClient globalClient = GlobalClientElf.globalClient();
    private final WebClient.Builder builder = WebClient.builder();

    public WfReq() {
    }

    public WfReq(String baseUrl) {
        super(baseUrl);
    }

    public WebClient buildWebClient() {
        WebClient buildClient = (WebClient)Condition.notNullThen((Object)this.builder, WebClient.Builder::build);
        return (WebClient)Condition.nullThen((Object)buildClient, () -> globalClient);
    }

    public Instance buildInstance() {
        return new Instance(this, this.buildWebClient());
    }

    public Mono<String> get() {
        return this.buildInstance().get();
    }

    public Mono<String> post() {
        return this.buildInstance().post();
    }

    public CompletableFuture<String> getFuture() {
        return this.buildInstance().getFuture();
    }

    public CompletableFuture<String> postFuture() {
        return this.buildInstance().postFuture();
    }

    @Generated
    public WebClient.Builder baseUrl(String baseUrl) {
        return this.builder.baseUrl(baseUrl);
    }

    @Generated
    public WebClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        return this.builder.defaultUriVariables(defaultUriVariables);
    }

    @Generated
    public WebClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        return this.builder.uriBuilderFactory(uriBuilderFactory);
    }

    @Generated
    public WebClient.Builder defaultHeader(String header, String ... values) {
        return this.builder.defaultHeader(header, values);
    }

    @Generated
    public WebClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        return this.builder.defaultHeaders(headersConsumer);
    }

    @Generated
    public WebClient.Builder defaultCookie(String cookie, String ... values) {
        return this.builder.defaultCookie(cookie, values);
    }

    @Generated
    public WebClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        return this.builder.defaultCookies(cookiesConsumer);
    }

    @Generated
    public WebClient.Builder defaultRequest(Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest) {
        return this.builder.defaultRequest(defaultRequest);
    }

    @Generated
    public WebClient.Builder defaultStatusHandler(Predicate<HttpStatusCode> statusPredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
        return this.builder.defaultStatusHandler(statusPredicate, exceptionFunction);
    }

    @Generated
    public WebClient.Builder filter(ExchangeFilterFunction filter) {
        return this.builder.filter(filter);
    }

    @Generated
    public WebClient.Builder filters(Consumer<List<ExchangeFilterFunction>> filtersConsumer) {
        return this.builder.filters(filtersConsumer);
    }

    @Generated
    public WebClient.Builder clientConnector(ClientHttpConnector connector) {
        return this.builder.clientConnector(connector);
    }

    @Generated
    public WebClient.Builder codecs(Consumer<ClientCodecConfigurer> configurer) {
        return this.builder.codecs(configurer);
    }

    @Generated
    public WebClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        return this.builder.exchangeStrategies(strategies);
    }

    @Deprecated
    @Generated
    public WebClient.Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> configurer) {
        return this.builder.exchangeStrategies(configurer);
    }

    @Generated
    public WebClient.Builder exchangeFunction(ExchangeFunction exchangeFunction) {
        return this.builder.exchangeFunction(exchangeFunction);
    }

    @Generated
    public WebClient.Builder observationRegistry(ObservationRegistry observationRegistry) {
        return this.builder.observationRegistry(observationRegistry);
    }

    @Generated
    public WebClient.Builder observationConvention(ClientRequestObservationConvention observationConvention) {
        return this.builder.observationConvention(observationConvention);
    }

    @Generated
    public WebClient.Builder apply(Consumer<WebClient.Builder> builderConsumer) {
        return this.builder.apply(builderConsumer);
    }

    @Generated
    public WebClient build() {
        return this.builder.build();
    }

    public static final class Instance
    extends CommonReq.Instance<Instance> {
        private final WebClient webClient;

        public <U extends CommonReq<U>> Instance(CommonReq<U> other, WebClient webClient) {
            super(other);
            this.webClient = webClient;
        }

        @Override
        public Instance copy() {
            return new Instance(this, this.webClient);
        }

        public Mono<String> get() {
            return this.execute(this::buildGetRequestSpec);
        }

        public Mono<String> post() {
            return this.execute(this::buildPostRequestSpec);
        }

        public CompletableFuture<String> getFuture() {
            return this.get().toFuture();
        }

        public CompletableFuture<String> postFuture() {
            return this.post().toFuture();
        }

        private Mono<String> execute(Supplier<WebClient.RequestBodyUriSpec> requestSpecSupplier) {
            return requestSpecSupplier.get().exchangeToMono(this::processResponse);
        }

        private WebClient.RequestBodyUriSpec buildGetRequestSpec() {
            Map<String, Object> parameterMap = this.fetchParameterMap();
            String requestUrl = this.concatRequestUrl(parameterMap);
            String query = CommonConstant.URL_QUERY_FORMATTER.format(parameterMap, Mapp.newHashMap());
            Map<String, String> headersMap = this.buildHeadersMap();
            WebClient.RequestBodyUriSpec spec = this.webClient.method(HttpMethod.GET);
            spec.uri(Url.concatUrlQuery((String)requestUrl, (String)query), new Object[0]);
            spec.headers(httpHeaders -> httpHeaders.setAll(headersMap));
            return spec;
        }

        private WebClient.RequestBodyUriSpec buildPostRequestSpec() {
            Map<String, Object> parameterMap = this.fetchParameterMap();
            String requestUrl = this.concatRequestUrl(parameterMap);
            Map<String, String> headersMap = this.buildHeadersMap();
            String content = (String)Condition.nullThen((Object)this.requestBody, () -> this.contentFormatter().format(parameterMap, Mapp.newHashMap()));
            String contentType = (String)Condition.nullThen((Object)headersMap.get("Content-Type"), CommonConstant.DEFAULT_CONTENT_FORMATTER::contentType);
            WebClient.RequestBodyUriSpec spec = this.webClient.method(HttpMethod.POST);
            spec.uri(requestUrl, new Object[0]);
            spec.contentType(MediaType.parseMediaType((String)contentType));
            spec.body(BodyInserters.fromValue((Object)content));
            spec.headers(httpHeaders -> httpHeaders.setAll(headersMap));
            return spec;
        }

        private Map<String, String> buildHeadersMap() {
            Map headersMap = Mapp.newHashMap();
            String acceptCharsetName = this.acceptCharset().name();
            headersMap.put("Accept-Charset", acceptCharsetName);
            String contentType = this.contentFormatter().contentType();
            headersMap.put("Content-Type", contentType);
            for (Pair<String, String> header : this.headers()) {
                Condition.checkNull((Object)((String)header.getValue()), () -> (String)headersMap.remove(header.getKey()), xx -> headersMap.put((String)header.getKey(), (String)header.getValue()));
            }
            return headersMap;
        }

        private Mono<String> processResponse(ClientResponse clientResponse) {
            int statusCode = clientResponse.statusCode().value();
            Mono responseBody = clientResponse.bodyToMono(byte[].class);
            FallbackFunction<?> statusFallback = this.statusFallbackMapping().get((Object)HttpStatus.valueOf(statusCode));
            if (Objects.nonNull(statusFallback)) {
                return responseBody.map(bytes -> this.applyFallback((byte[])bytes, statusFallback, statusCode, (Mono<byte[]>)responseBody));
            }
            FallbackFunction<?> statusSeriesFallback = this.statusSeriesFallbackMapping().get((Object)HttpStatus.Series.valueOf(statusCode));
            if (Objects.nonNull(statusSeriesFallback)) {
                return responseBody.map(bytes -> this.applyFallback((byte[])bytes, statusSeriesFallback, statusCode, (Mono<byte[]>)responseBody));
            }
            return responseBody.map(this::extractResponseString);
        }

        private String applyFallback(final byte[] bytes, FallbackFunction<?> function, int statusCode, Mono<byte[]> responseBody) {
            return Str.toStr(function.apply(new FallbackFunction.Response<Mono<byte[]>>(statusCode, responseBody){

                @Override
                public String responseBodyAsString() {
                    return this.extractResponseString(bytes);
                }
            }));
        }

        private String extractResponseString(byte[] bytes) {
            return Bytes.string((byte[])bytes, (Charset)this.acceptCharset());
        }
    }
}

