/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.wfclient.elf;

import com.github.charlemaznable.httpclient.logging.LoggingWfInterceptor;
import com.github.charlemaznable.httpclient.westcache.WestCacheConstant;
import com.github.charlemaznable.httpclient.westcache.WestCacheWfInterceptor;
import com.github.charlemaznable.httpclient.wfclient.elf.GlobalClientSupplier;
import java.util.Iterator;
import java.util.ServiceLoader;
import lombok.Generated;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

public final class GlobalClientElf {
    private static final WebClient instance = GlobalClientElf.findSupplier().supply();

    public static WebClient globalClient() {
        return instance;
    }

    private static GlobalClientSupplier findSupplier() {
        Iterator<GlobalClientSupplier> suppliers = ServiceLoader.load(GlobalClientSupplier.class).iterator();
        if (!suppliers.hasNext()) {
            return new DefaultGlobalClientSupplier();
        }
        GlobalClientSupplier result = suppliers.next();
        if (suppliers.hasNext()) {
            throw new IllegalStateException("Multiple GlobalClientSupplier Found");
        }
        return result;
    }

    @Generated
    private GlobalClientElf() {
    }

    public static class DefaultGlobalClientSupplier
    implements GlobalClientSupplier {
        @Override
        public WebClient supply() {
            WebClient.Builder builder = WebClient.builder();
            builder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector());
            builder.filter((ExchangeFilterFunction)new LoggingWfInterceptor());
            if (WestCacheConstant.HAS_WESTCACHE) {
                builder.filter((ExchangeFilterFunction)new WestCacheWfInterceptor());
            }
            return builder.build();
        }
    }
}

