/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.httpclient.wfclient.internal;

import com.github.charlemaznable.core.codec.Bytes;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Mapp;
import com.github.charlemaznable.core.net.Url;
import com.github.charlemaznable.httpclient.common.CommonConstant;
import com.github.charlemaznable.httpclient.common.CommonExecute;
import com.github.charlemaznable.httpclient.common.CommonReq;
import com.github.charlemaznable.httpclient.wfclient.elf.RequestSpecConfigElf;
import com.github.charlemaznable.httpclient.wfclient.internal.WfBase;
import com.github.charlemaznable.httpclient.wfclient.internal.WfMethod;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

final class WfExecute
extends CommonExecute<WfBase, WfMethod, ResponseEntity<byte[]>, byte[]> {
    public WfExecute(WfMethod wfMethod) {
        super(new WfBase((WfBase)wfMethod.element().base()), wfMethod);
    }

    @Override
    protected boolean processParameterType(Object argument, Class<?> parameterType) {
        if (argument instanceof WebClient) {
            WebClient client;
            ((WfBase)this.base()).client = client = (WebClient)argument;
            return true;
        }
        return super.processParameterType(argument, parameterType);
    }

    @Override
    public Object execute() {
        return this.adaptationFromFuture(this.decorateAsyncExecute(() -> this.buildRequestSpec().exchangeToMono(this::buildWfResponse).mapNotNull(this::processResponse).toFuture()));
    }

    private WebClient.RequestBodyUriSpec buildRequestSpec() {
        Condition.notNullThenRun((Object)((WfBase)this.base()).requestExtender(), extender -> extender.extend(((WfBase)this.base()).headers(), ((WfBase)this.base()).pathVars(), ((WfBase)this.base()).parameters(), ((WfBase)this.base()).contexts()));
        Map headersMap = Mapp.newHashMap();
        String acceptCharsetName = ((WfBase)this.base()).acceptCharset().name();
        headersMap.put("Accept-Charset", acceptCharsetName);
        String contentType = ((WfBase)this.base()).contentFormatter().contentType();
        headersMap.put("Content-Type", contentType);
        for (Pair<String, String> header : ((WfBase)this.base()).headers()) {
            Condition.checkNull((Object)((String)header.getValue()), () -> (String)headersMap.remove(header.getKey()), xx -> headersMap.put((String)header.getKey(), (String)header.getValue()));
        }
        CommonExecute.CommonExecuteParams executeParams = this.buildCommonExecuteParams();
        WebClient.RequestBodyUriSpec spec = ((WfBase)this.base()).client.method(HttpMethod.valueOf((String)executeParams.requestMethod()));
        spec.headers(httpHeaders -> httpHeaders.setAll(headersMap));
        if (!CommonReq.permitsRequestBody(executeParams.requestMethod()).booleanValue()) {
            String query = CommonConstant.URL_QUERY_FORMATTER.format(executeParams.parameterMap(), executeParams.contextMap());
            spec.uri(Url.concatUrlQuery((String)executeParams.requestUrl(), (String)query), new Object[0]);
        } else {
            String content = (String)Condition.nullThen((Object)this.requestBodyRaw(), () -> ((WfBase)this.base()).contentFormatter().format(executeParams.parameterMap(), executeParams.contextMap()));
            String contentTypeHeader = (String)Condition.nullThen((Object)((String)headersMap.get("Content-Type")), CommonConstant.DEFAULT_CONTENT_FORMATTER::contentType);
            spec.uri(executeParams.requestUrl(), new Object[0]);
            spec.contentType(MediaType.parseMediaType((String)contentTypeHeader));
            spec.body(BodyInserters.fromValue((Object)content));
            spec.attribute("RequestBodyAsStringSpecAttributeKey", (Object)content);
        }
        RequestSpecConfigElf.configRequestSpec(spec, this);
        return spec;
    }

    private Mono<ResponseEntity<byte[]>> buildWfResponse(ClientResponse clientResponse) {
        return clientResponse.toEntity(byte[].class);
    }

    @Override
    protected int getResponseCode(ResponseEntity<byte[]> response) {
        return response.getStatusCode().value();
    }

    @Override
    protected byte[] getResponseBody(ResponseEntity<byte[]> response) {
        return (byte[])Condition.nullThen((Object)((byte[])response.getBody()), () -> new byte[0]);
    }

    @Override
    protected String getResponseBodyString(byte[] responseBody) {
        return Bytes.string((byte[])responseBody, (Charset)((WfBase)this.base()).acceptCharset());
    }

    @Override
    protected Object customProcessReturnTypeValue(int statusCode, byte[] responseBody, Class<?> returnType) {
        if (byte[].class == returnType) {
            return responseBody;
        }
        return super.customProcessReturnTypeValue(statusCode, responseBody, returnType);
    }
}

