/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.codec;

import com.github.charlemaznable.codec.Bytes;

public class Base16 {
    public static String base16(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            if ((aByte & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Long.toString(aByte & 0xFF, 16));
        }
        return sb.toString();
    }

    public static String base16FromString(String str) {
        return Base16.base16(Bytes.bytes(str));
    }

    public static byte[] unBase16(String value) {
        byte[] bytes = new byte[value.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(value.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String unBase16AsString(String value) {
        return Bytes.string(Base16.unBase16(value));
    }
}

