/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.codec;

import java.io.ByteArrayOutputStream;

public class Base62 {
    private static char[] encodes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static byte[] decodes = new byte[256];

    public static String base64(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        int pos = 0;
        int val = 0;
        for (byte b : data) {
            val = val << 8 | b & 0xFF;
            pos += 8;
            while (pos > 5) {
                sb.append(encodes[val >> (pos -= 6)]);
                val &= (1 << pos) - 1;
            }
        }
        if (pos > 0) {
            sb.append(encodes[val << 6 - pos]);
        }
        return sb.toString();
    }

    public static byte[] unBase64(String dataStr) {
        char[] data = dataStr.toCharArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
        int pos = 0;
        int val = 0;
        for (char c : data) {
            val = val << 6 | decodes[c];
            pos += 6;
            while (pos > 7) {
                baos.write(val >> (pos -= 8));
                val &= (1 << pos) - 1;
            }
        }
        return baos.toByteArray();
    }

    public static String base62(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        int pos = 0;
        int val = 0;
        for (byte b : data) {
            val = val << 8 | b & 0xFF;
            pos += 8;
            while (pos > 5) {
                char c = encodes[val >> (pos -= 6)];
                sb.append(c == 'i' ? "ia" : (c == '+' ? "ib" : (c == '/' ? "ic" : String.valueOf(c))));
                val &= (1 << pos) - 1;
            }
        }
        if (pos > 0) {
            char c = encodes[val << 6 - pos];
            sb.append(c == 'i' ? "ia" : (c == '+' ? "ib" : (c == '/' ? "ic" : String.valueOf(c))));
        }
        return sb.toString();
    }

    public static byte[] unBase62(String dataStr) {
        char[] data = dataStr.toCharArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
        int pos = 0;
        int val = 0;
        for (int i = 0; i < data.length; ++i) {
            int c = data[i];
            if (c == 105) {
                c = (c = data[++i]) == 97 ? 105 : (c == 98 ? 43 : (c == 99 ? 47 : data[--i]));
            }
            val = val << 6 | decodes[c];
            pos += 6;
            while (pos > 7) {
                baos.write(val >> (pos -= 8));
                val &= (1 << pos) - 1;
            }
        }
        return baos.toByteArray();
    }

    static {
        for (int i = 0; i < encodes.length; ++i) {
            Base62.decodes[Base62.encodes[i]] = (byte)i;
        }
    }
}

