/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.codec;

import com.github.charlemaznable.codec.Bytes;
import com.github.charlemaznable.lang.Str;
import java.math.BigInteger;
import java.util.Arrays;

public class Base64 {
    public static String base64(byte[] bytes) {
        return Base64.base64(bytes, Format.Standard);
    }

    public static String padding(String s) {
        return Str.padding(s, '=', (4 - s.length() % 4) % 4);
    }

    public static String purify(String s) {
        return Str.removeLastLetters(s, '=');
    }

    public static String base64(String s) {
        return Base64.base64(s, Format.Standard);
    }

    public static String base64(String s, Format format) {
        return Base64.base64(Bytes.bytes(s), format);
    }

    public static String base64(byte[] bytes, Format format) {
        switch (format) {
            case Standard: {
                return ApacheBase64.encodeBase64String(bytes);
            }
            case UrlSafe: {
                return Base64.purify(ApacheBase64.encodeBase64URLSafeString(bytes));
            }
            case Purified: {
                return Base64.purify(ApacheBase64.encodeBase64String(bytes));
            }
        }
        return null;
    }

    public static byte[] unBase64(String value) {
        return ApacheBase64.decodeBase64(Base64.padding(value));
    }

    public static String unBase64AsString(String value) {
        return Bytes.string(Base64.unBase64(value));
    }

    private static class ApacheBase64
    extends ApacheBaseNCodec {
        static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
        private static final int BITS_PER_ENCODED_BYTE = 6;
        private static final int BYTES_PER_UNENCODED_BLOCK = 3;
        private static final int BYTES_PER_ENCODED_BLOCK = 4;
        private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        private static final int MASK_6BITS = 63;
        private final byte[] encodeTable;
        private final byte[] decodeTable = DECODE_TABLE;
        private final byte[] lineSeparator;
        private final int decodeSize;
        private final int encodeSize;

        public ApacheBase64() {
            this(0);
        }

        public ApacheBase64(boolean urlSafe) {
            this(76, CHUNK_SEPARATOR, urlSafe);
        }

        public ApacheBase64(int lineLength) {
            this(lineLength, CHUNK_SEPARATOR);
        }

        public ApacheBase64(int lineLength, byte[] lineSeparator) {
            this(lineLength, lineSeparator, false);
        }

        public ApacheBase64(int lineLength, byte[] lineSeparator, boolean urlSafe) {
            super(3, 4, lineLength, lineSeparator == null ? 0 : lineSeparator.length);
            if (lineSeparator != null) {
                if (this.containsAlphabetOrPad(lineSeparator)) {
                    String sep = Bytes.string(lineSeparator);
                    throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + sep + "]");
                }
                if (lineLength > 0) {
                    this.encodeSize = 4 + lineSeparator.length;
                    this.lineSeparator = new byte[lineSeparator.length];
                    System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
                } else {
                    this.encodeSize = 4;
                    this.lineSeparator = null;
                }
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
            this.decodeSize = this.encodeSize - 1;
            this.encodeTable = urlSafe ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
        }

        @Deprecated
        public static boolean isArrayByteBase64(byte[] arrayOctet) {
            return ApacheBase64.isBase64(arrayOctet);
        }

        public static boolean isBase64(byte octet) {
            return octet == 61 || octet >= 0 && octet < DECODE_TABLE.length && DECODE_TABLE[octet] != -1;
        }

        public static boolean isBase64(String base64) {
            return ApacheBase64.isBase64(Bytes.bytes(base64));
        }

        public static boolean isBase64(byte[] arrayOctet) {
            for (byte anArrayOctet : arrayOctet) {
                if (ApacheBase64.isBase64(anArrayOctet) || ApacheBase64.isWhiteSpace(anArrayOctet)) continue;
                return false;
            }
            return true;
        }

        public static byte[] encodeBase64(byte[] binaryData) {
            return ApacheBase64.encodeBase64(binaryData, false);
        }

        public static String encodeBase64String(byte[] binaryData) {
            return Bytes.string(ApacheBase64.encodeBase64(binaryData, false));
        }

        public static byte[] encodeBase64URLSafe(byte[] binaryData) {
            return ApacheBase64.encodeBase64(binaryData, false, true);
        }

        public static String encodeBase64URLSafeString(byte[] binaryData) {
            return Bytes.string(ApacheBase64.encodeBase64(binaryData, false, true));
        }

        public static byte[] encodeBase64Chunked(byte[] binaryData) {
            return ApacheBase64.encodeBase64(binaryData, true);
        }

        public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
            return ApacheBase64.encodeBase64(binaryData, isChunked, false);
        }

        public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe) {
            return ApacheBase64.encodeBase64(binaryData, isChunked, urlSafe, Integer.MAX_VALUE);
        }

        public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe, int maxResultSize) {
            if (binaryData == null || binaryData.length == 0) {
                return binaryData;
            }
            ApacheBase64 b64 = isChunked ? new ApacheBase64(urlSafe) : new ApacheBase64(0, CHUNK_SEPARATOR, urlSafe);
            long len = b64.getEncodedLength(binaryData);
            if (len > (long)maxResultSize) {
                throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + len + ") than the specified maximum size of " + maxResultSize);
            }
            return b64.encode(binaryData);
        }

        public static byte[] decodeBase64(String base64String) {
            return new ApacheBase64().decode(base64String);
        }

        public static byte[] decodeBase64(byte[] base64Data) {
            return new ApacheBase64().decode(base64Data);
        }

        public static BigInteger decodeInteger(byte[] pArray) {
            return new BigInteger(1, ApacheBase64.decodeBase64(pArray));
        }

        public static byte[] encodeInteger(BigInteger bigInt) {
            if (bigInt == null) {
                throw new NullPointerException("encodeInteger called with null parameter");
            }
            return ApacheBase64.encodeBase64(ApacheBase64.toIntegerBytes(bigInt), false);
        }

        static byte[] toIntegerBytes(BigInteger bigInt) {
            int bitlen = bigInt.bitLength();
            bitlen = bitlen + 7 >> 3 << 3;
            byte[] bigBytes = bigInt.toByteArray();
            if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
                return bigBytes;
            }
            int startSrc = 0;
            int len = bigBytes.length;
            if (bigInt.bitLength() % 8 == 0) {
                startSrc = 1;
                --len;
            }
            int startDst = bitlen / 8 - len;
            byte[] resizedBytes = new byte[bitlen / 8];
            System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
            return resizedBytes;
        }

        public boolean isUrlSafe() {
            return this.encodeTable == URL_SAFE_ENCODE_TABLE;
        }

        @Override
        void encode(byte[] in, int inPos, int inAvail, ApacheBaseNCodec.Context context) {
            if (context.eof) {
                return;
            }
            if (inAvail < 0) {
                context.eof = true;
                if (0 == context.modulus && this.lineLength == 0) {
                    return;
                }
                byte[] buffer = this.ensureBufferSize(this.encodeSize, context);
                int savedPos = context.pos;
                switch (context.modulus) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 2 & 0x3F];
                        buffer[context.pos++] = this.encodeTable[context.ibitWorkArea << 4 & 0x3F];
                        if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                        buffer[context.pos++] = this.pad;
                        buffer[context.pos++] = this.pad;
                        break;
                    }
                    case 2: {
                        buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 10 & 0x3F];
                        buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 4 & 0x3F];
                        buffer[context.pos++] = this.encodeTable[context.ibitWorkArea << 2 & 0x3F];
                        if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                        buffer[context.pos++] = this.pad;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Impossible modulus " + context.modulus);
                    }
                }
                context.currentLinePos += context.pos - savedPos;
                if (this.lineLength > 0 && context.currentLinePos > 0) {
                    System.arraycopy(this.lineSeparator, 0, buffer, context.pos, this.lineSeparator.length);
                    context.pos += this.lineSeparator.length;
                }
            } else {
                for (int i = 0; i < inAvail; ++i) {
                    int b;
                    byte[] buffer = this.ensureBufferSize(this.encodeSize, context);
                    context.modulus = (context.modulus + 1) % 3;
                    if ((b = in[inPos++]) < 0) {
                        b += 256;
                    }
                    context.ibitWorkArea = (context.ibitWorkArea << 8) + b;
                    if (0 != context.modulus) continue;
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 18 & 0x3F];
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 12 & 0x3F];
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 6 & 0x3F];
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea & 0x3F];
                    context.currentLinePos += 4;
                    if (this.lineLength <= 0 || this.lineLength > context.currentLinePos) continue;
                    System.arraycopy(this.lineSeparator, 0, buffer, context.pos, this.lineSeparator.length);
                    context.pos += this.lineSeparator.length;
                    context.currentLinePos = 0;
                }
            }
        }

        @Override
        void decode(byte[] in, int inPos, int inAvail, ApacheBaseNCodec.Context context) {
            if (context.eof) {
                return;
            }
            if (inAvail < 0) {
                context.eof = true;
            }
            for (int i = 0; i < inAvail; ++i) {
                byte result;
                byte b;
                byte[] buffer = this.ensureBufferSize(this.decodeSize, context);
                if ((b = in[inPos++]) == this.pad) {
                    context.eof = true;
                    break;
                }
                if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
                context.modulus = (context.modulus + 1) % 4;
                context.ibitWorkArea = (context.ibitWorkArea << 6) + result;
                if (context.modulus != 0) continue;
                buffer[context.pos++] = (byte)(context.ibitWorkArea >> 16 & 0xFF);
                buffer[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
                buffer[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
            }
            if (context.eof && context.modulus != 0) {
                byte[] buffer = this.ensureBufferSize(this.decodeSize, context);
                switch (context.modulus) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        context.ibitWorkArea >>= 4;
                        buffer[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                        break;
                    }
                    case 3: {
                        context.ibitWorkArea >>= 2;
                        buffer[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
                        buffer[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Impossible modulus " + context.modulus);
                    }
                }
            }
        }

        @Override
        protected boolean isInAlphabet(byte octet) {
            return octet >= 0 && octet < this.decodeTable.length && this.decodeTable[octet] != -1;
        }
    }

    private static abstract class ApacheBaseNCodec {
        public static final int MIME_CHUNK_SIZE = 76;
        protected static final int MASK_8BITS = 255;
        protected static final byte PAD_DEFAULT = 61;
        static final int EOF = -1;
        private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
        private static final int DEFAULT_BUFFER_SIZE = 8192;
        @Deprecated
        protected final byte PAD = (byte)61;
        protected final byte pad;
        protected final int lineLength;
        private final int unencodedBlockSize;
        private final int encodedBlockSize;
        private final int chunkSeparatorLength;

        protected ApacheBaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
            this(unencodedBlockSize, encodedBlockSize, lineLength, chunkSeparatorLength, 61);
        }

        protected ApacheBaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength, byte pad) {
            this.unencodedBlockSize = unencodedBlockSize;
            this.encodedBlockSize = encodedBlockSize;
            boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
            this.lineLength = useChunking ? lineLength / encodedBlockSize * encodedBlockSize : 0;
            this.chunkSeparatorLength = chunkSeparatorLength;
            this.pad = pad;
        }

        protected static boolean isWhiteSpace(byte byteToCheck) {
            switch (byteToCheck) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    return true;
                }
            }
            return false;
        }

        boolean hasData(Context context) {
            return context.buffer != null;
        }

        int available(Context context) {
            return context.buffer != null ? context.pos - context.readPos : 0;
        }

        protected int getDefaultBufferSize() {
            return 8192;
        }

        private byte[] resizeBuffer(Context context) {
            if (context.buffer == null) {
                context.buffer = new byte[this.getDefaultBufferSize()];
                context.pos = 0;
                context.readPos = 0;
            } else {
                byte[] b = new byte[context.buffer.length * 2];
                System.arraycopy(context.buffer, 0, b, 0, context.buffer.length);
                context.buffer = b;
            }
            return context.buffer;
        }

        protected byte[] ensureBufferSize(int size, Context context) {
            if (context.buffer == null || context.buffer.length < context.pos + size) {
                return this.resizeBuffer(context);
            }
            return context.buffer;
        }

        int readResults(byte[] b, int bPos, int bAvail, Context context) {
            if (context.buffer != null) {
                int len = Math.min(this.available(context), bAvail);
                System.arraycopy(context.buffer, context.readPos, b, bPos, len);
                context.readPos += len;
                if (context.readPos >= context.pos) {
                    context.buffer = null;
                }
                return len;
            }
            return context.eof ? -1 : 0;
        }

        public Object encode(Object obj) {
            if (!(obj instanceof byte[])) {
                throw new RuntimeException("Parameter supplied to Base-N encode is not a byte[]");
            }
            return this.encode((byte[])obj);
        }

        public String encodeToString(byte[] pArray) {
            return Bytes.string(this.encode(pArray));
        }

        public String encodeAsString(byte[] pArray) {
            return Bytes.string(this.encode(pArray));
        }

        public Object decode(Object obj) {
            if (obj instanceof byte[]) {
                return this.decode((byte[])obj);
            }
            if (obj instanceof String) {
                return this.decode((String)obj);
            }
            throw new RuntimeException("Parameter supplied to Base-N decode is not a byte[] or a String");
        }

        public byte[] decode(String pArray) {
            return this.decode(Bytes.bytes(pArray));
        }

        public byte[] decode(byte[] pArray) {
            if (pArray == null || pArray.length == 0) {
                return pArray;
            }
            Context context = new Context();
            this.decode(pArray, 0, pArray.length, context);
            this.decode(pArray, 0, -1, context);
            byte[] result = new byte[context.pos];
            this.readResults(result, 0, result.length, context);
            return result;
        }

        public byte[] encode(byte[] pArray) {
            if (pArray == null || pArray.length == 0) {
                return pArray;
            }
            Context context = new Context();
            this.encode(pArray, 0, pArray.length, context);
            this.encode(pArray, 0, -1, context);
            byte[] buf = new byte[context.pos - context.readPos];
            this.readResults(buf, 0, buf.length, context);
            return buf;
        }

        abstract void encode(byte[] var1, int var2, int var3, Context var4);

        abstract void decode(byte[] var1, int var2, int var3, Context var4);

        protected abstract boolean isInAlphabet(byte var1);

        public boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
            for (byte anArrayOctet : arrayOctet) {
                if (this.isInAlphabet(anArrayOctet) || allowWSPad && (anArrayOctet == this.pad || ApacheBaseNCodec.isWhiteSpace(anArrayOctet))) continue;
                return false;
            }
            return true;
        }

        public boolean isInAlphabet(String basen) {
            return this.isInAlphabet(Bytes.bytes(basen), true);
        }

        protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
            if (arrayOctet == null) {
                return false;
            }
            for (byte element : arrayOctet) {
                if (this.pad != element && !this.isInAlphabet(element)) continue;
                return true;
            }
            return false;
        }

        public long getEncodedLength(byte[] pArray) {
            long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
            if (this.lineLength > 0) {
                len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
            }
            return len;
        }

        static class Context {
            int ibitWorkArea;
            long lbitWorkArea;
            byte[] buffer;
            int pos;
            int readPos;
            boolean eof;
            int currentLinePos;
            int modulus;

            Context() {
            }

            public String toString() {
                return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
            }
        }
    }

    public static enum Format {
        Standard,
        UrlSafe,
        Purified;

    }
}

