/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.config;

import com.github.charlemaznable.config.Configable;
import com.github.charlemaznable.config.impl.ConfigBuilder;
import com.github.charlemaznable.config.impl.DefConfigSetter;
import com.github.charlemaznable.config.impl.IniConfigable;
import com.github.charlemaznable.config.impl.PropertiesConfigable;
import com.github.charlemaznable.config.impl.PropsConfigable;
import com.github.charlemaznable.config.impl.TableConfigable;
import com.github.charlemaznable.config.utils.ParamsApplyUtils;
import com.github.charlemaznable.lang.ClzPath;
import com.github.charlemaznable.lang.Str;
import java.net.URL;
import java.util.List;
import java.util.Properties;

public class Config {
    private static Configable impl;

    private static void loadConfigImplementation() {
        Configable defConfig = Config.createConfigable("defconfigdir", "defconfig", null);
        Configable bizConfig = Config.createConfigable("bizconfigdir", "bizconfig", defConfig);
        String configImplementation = bizConfig.getStr("config.implementation");
        if (Str.isEmpty(configImplementation)) {
            impl = bizConfig;
            return;
        }
        impl = Config.loadImpl(configImplementation, bizConfig);
        if (impl instanceof DefConfigSetter) {
            ((DefConfigSetter)((Object)impl)).setDefConfig(defConfig);
        }
    }

    private static Configable loadImpl(String configImplementation, Configable defConfig) {
        return ParamsApplyUtils.createObject(configImplementation, Configable.class);
    }

    private static Configable createConfigable(String configKey, String defConfigDir, Configable defConfig) {
        URL[] tablesURL;
        URL[] inisURL;
        URL[] propsURL;
        URL[] propertiesURL;
        ConfigBuilder configBuilder = new ConfigBuilder();
        configBuilder.setDefConfig(defConfig);
        String basePackage = defConfigDir;
        URL envURL = ClzPath.classResource("envspace.props");
        if (envURL != null) {
            PropsConfigable envSpaceConfig = new PropsConfigable(envURL);
            basePackage = envSpaceConfig.getStr(configKey, defConfigDir);
            configBuilder.addConfig(envSpaceConfig);
        }
        for (URL propertyURL : propertiesURL = ClzPath.classResources(basePackage, "properties")) {
            configBuilder.addConfig(new PropertiesConfigable(propertyURL));
        }
        for (URL propURL : propsURL = ClzPath.classResources(basePackage, "props")) {
            configBuilder.addConfig(new PropsConfigable(propURL));
        }
        for (URL iniURL : inisURL = ClzPath.classResources(basePackage, "ini")) {
            configBuilder.addConfig(new IniConfigable(iniURL));
        }
        for (URL tableURL : tablesURL = ClzPath.classResources(basePackage, "table")) {
            configBuilder.addConfig(new TableConfigable(tableURL));
        }
        return configBuilder.buildConfig();
    }

    public static boolean exists(String key) {
        return impl.exists(key);
    }

    public static Properties getProperties() {
        return impl.getProperties();
    }

    public static int getInt(String key) {
        return impl.getInt(key);
    }

    public static long getLong(String key) {
        return impl.getLong(key);
    }

    public static boolean getBool(String key) {
        return impl.getBool(key);
    }

    public static float getFloat(String key) {
        return impl.getFloat(key);
    }

    public static double getDouble(String key) {
        return impl.getDouble(key);
    }

    public static String getStr(String key) {
        return impl.getStr(key);
    }

    public static int getInt(String key, int defaultValue) {
        return impl.getInt(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return impl.getLong(key, defaultValue);
    }

    public static boolean getBool(String key, boolean defaultValue) {
        return impl.getBool(key, defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        return impl.getFloat(key, defaultValue);
    }

    public static double getDouble(String key, double defaultValue) {
        return impl.getDouble(key, defaultValue);
    }

    public static String getStr(String key, String defaultValue) {
        return impl.getStr(key, defaultValue);
    }

    public static Configable subset(String prefix) {
        return impl.subset(prefix);
    }

    public static long refreshConfigSet(String prefix) {
        return impl.refreshConfigSet(prefix);
    }

    public static <T> T getBean(String key, Class<T> beanClass) {
        return impl.getBean(key, beanClass);
    }

    public static <T> List<T> getBeans(String key, Class<T> beanClass) {
        return impl.getBeans(key, beanClass);
    }

    public static Configable getConfigImpl() {
        return impl;
    }

    static {
        Config.loadConfigImplementation();
    }
}

