/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.config.impl;

import com.github.charlemaznable.codec.Base64;
import com.github.charlemaznable.config.Configable;
import com.github.charlemaznable.config.impl.BaseConfigable;
import com.github.charlemaznable.crypto.AES;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class DefaultConfigable
extends BaseConfigable {
    private Properties properties;

    public DefaultConfigable() {
        this.properties = new Properties();
    }

    public DefaultConfigable(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean exists(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String getStr(String key) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            return null;
        }
        if (StringUtils.startsWith((CharSequence)(property = StringSubstitutor.replace((Object)property, (Properties)this.properties)), (CharSequence)"{AES}")) {
            property = AES.decrypt(Base64.unBase64(property.substring(5)), "defaultconfig");
        }
        return StringUtils.trim((String)property);
    }

    @Override
    public Configable subset(String prefix) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return new DefaultConfigable(new Properties());
        }
        String prefixMatch = prefix.charAt(prefix.length() - 1) != '.' ? prefix + '.' : prefix;
        Properties subProps = this.subProperties(this.properties, prefixMatch);
        return new DefaultConfigable(subProps);
    }

    protected Properties subProperties(Properties properties, String prefixMatch) {
        Properties subProps = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefixMatch)) continue;
            subProps.put(key.substring(prefixMatch.length()), entry.getValue());
        }
        return subProps;
    }

    @Override
    public long refreshConfigSet(String prefix) {
        return System.currentTimeMillis();
    }
}

