/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.config.impl;

import com.github.charlemaznable.config.ex.ConfigException;
import com.github.charlemaznable.config.impl.DefaultConfigable;
import com.github.charlemaznable.config.impl.IniReader;
import com.github.charlemaznable.lang.ClzPath;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class IniConfigable
extends DefaultConfigable {
    public IniConfigable(URL url) {
        super(IniConfigable.buildProperties(url));
    }

    private static Properties buildProperties(URL url) {
        InputStreamReader reader = null;
        Properties props = new Properties();
        try {
            reader = new InputStreamReader(Objects.requireNonNull(ClzPath.urlAsInputStream(url)), Charsets.UTF_8);
            IniReader iniReader = new IniReader(reader);
            for (String section : iniReader.getSections()) {
                Properties sectionProps = iniReader.getSection(section);
                if (sectionProps == null) continue;
                String prefix = section.equals("") ? "" : section + '.';
                for (Map.Entry<Object, Object> entry : sectionProps.entrySet()) {
                    String key = prefix + entry.getKey();
                    if (!props.containsKey(key)) {
                        props.put(key, entry.getValue().toString());
                        continue;
                    }
                    throw new ConfigException("duplicate key in file " + url + " line " + iniReader.getLineNumber());
                }
            }
        }
        catch (IOException ex) {
            try {
                throw new ConfigException("read ini file error " + url, ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)reader);
        return props;
    }
}

