/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.config.impl;

import com.github.charlemaznable.config.ex.ConfigException;
import com.github.charlemaznable.config.impl.ConfigTable;
import com.github.charlemaznable.config.impl.DefaultConfigable;
import com.github.charlemaznable.config.impl.TableReader;
import com.github.charlemaznable.lang.ClzPath;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class TableConfigable
extends DefaultConfigable {
    public TableConfigable(URL url) {
        super(TableConfigable.buildProperties(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties buildProperties(URL url) {
        Properties props = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(Objects.requireNonNull(ClzPath.urlAsInputStream(url)), Charsets.UTF_8);
            TableReader tableReader = new TableReader(reader);
            List<ConfigTable> tables = tableReader.getTables();
            for (ConfigTable table : tables) {
                String tableName = table.getTableName();
                if (props.containsKey(tableName)) {
                    throw new ConfigException("duplicate key [" + tableName + "] in file...");
                }
                props.put(tableName, table);
            }
        }
        catch (IOException iOException) {
            Closeables.closeQuietly(reader);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            throw throwable;
        }
        Closeables.closeQuietly((Reader)reader);
        return props;
    }
}

