/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.crypto;

import com.github.charlemaznable.codec.Bytes;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static byte[] encrypt(String value, Key key) {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, key);
        return cipher.doFinal(Bytes.bytes(value));
    }

    public static String decrypt(byte[] value, Key key) {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, key);
        byte[] decrypted = cipher.doFinal(value);
        return Bytes.string(decrypted);
    }

    public static byte[] encrypt(String value, String keyString) {
        return AES.encrypt(value, AES.getKey(keyString));
    }

    public static String decrypt(byte[] value, String keyString) {
        return AES.decrypt(value, AES.getKey(keyString));
    }

    public static byte[] encrypt(String value, String keyString, int keySize) {
        return AES.encrypt(value, AES.getKey(keyString, keySize));
    }

    public static String decrypt(byte[] value, String keyString, int keySize) {
        return AES.decrypt(value, AES.getKey(keyString, keySize));
    }

    private static Key getKey(String keyString) {
        return AES.getKey(keyString, 128);
    }

    private static Key getKey(String keyString, int size) {
        byte[] keyBytes = new byte[size >> 3];
        byte[] srcBytes = Bytes.bytes(keyString);
        if (srcBytes.length >= keyBytes.length) {
            System.arraycopy(srcBytes, 0, keyBytes, 0, keyBytes.length);
            return AES.keyFromString(keyBytes);
        }
        int pos = 0;
        while (pos + srcBytes.length < keyBytes.length) {
            System.arraycopy(srcBytes, 0, keyBytes, pos, srcBytes.length);
            pos += srcBytes.length;
        }
        System.arraycopy(srcBytes, 0, keyBytes, pos, keyBytes.length - pos);
        return AES.keyFromString(keyBytes);
    }

    private static Key keyFromString(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }
}

