/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.crypto;

import com.github.charlemaznable.codec.Base64;
import com.github.charlemaznable.codec.Bytes;
import com.github.charlemaznable.codec.Hex;
import com.github.charlemaznable.crypto.RSA;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public enum SHAXWithRSA {
    SHA1WithRSA{

        @Override
        protected String signAlgorithms() {
            return "SHA1WithRSA";
        }
    }
    ,
    SHA256WithRSA{

        @Override
        protected String signAlgorithms() {
            return "SHA256WithRSA";
        }
    };


    protected abstract String signAlgorithms();

    public byte[] sign(String plainText, String privateKey) {
        return this.sign(plainText, RSA.privateKey(privateKey));
    }

    public byte[] sign(String plainText, PrivateKey privateKey) {
        Signature signature = Signature.getInstance(this.signAlgorithms());
        signature.initSign(privateKey);
        signature.update(Bytes.bytes(plainText));
        return signature.sign();
    }

    public boolean verify(String plainText, byte[] sign, String publicKey) {
        return this.verify(plainText, sign, RSA.publicKey(publicKey));
    }

    public boolean verify(String plainText, byte[] sign, PublicKey publicKey) {
        Signature signature = Signature.getInstance(this.signAlgorithms());
        signature.initVerify(publicKey);
        signature.update(Bytes.bytes(plainText));
        return signature.verify(sign);
    }

    public String signBase64(String plainText, String privateKey) {
        return Base64.base64(this.sign(plainText, privateKey));
    }

    public String signBase64(String plainText, PrivateKey privateKey) {
        return Base64.base64(this.sign(plainText, privateKey));
    }

    public boolean verifyBase64(String plainText, String sign, String publicKey) {
        return this.verify(plainText, Base64.unBase64(sign), publicKey);
    }

    public boolean verifyBase64(String plainText, String sign, PublicKey publicKey) {
        return this.verify(plainText, Base64.unBase64(sign), publicKey);
    }

    public String signHex(String plainText, String privateKey) {
        return Hex.hex(this.sign(plainText, privateKey));
    }

    public String signHex(String plainText, PrivateKey privateKey) {
        return Hex.hex(this.sign(plainText, privateKey));
    }

    public boolean verifyHex(String plainText, String sign, String publicKey) {
        return this.verify(plainText, Hex.unHex(sign), publicKey);
    }

    public boolean verifyHex(String plainText, String sign, PublicKey publicKey) {
        return this.verify(plainText, Hex.unHex(sign), publicKey);
    }
}

