/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.lang;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class LoadingCachee {
    public static <K, V> LoadingCache<K, V> simpleCache(CacheLoader<K, V> loader) {
        return CacheBuilder.newBuilder().build(loader);
    }

    public static <K, V> LoadingCache<K, V> accessCache(CacheLoader<K, V> loader, Duration duration) {
        return LoadingCachee.accessCache(loader, duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public static <K, V> LoadingCache<K, V> accessCache(CacheLoader<K, V> loader, long duration, TimeUnit unit) {
        return CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build(loader);
    }

    public static <K, V> LoadingCache<K, V> writeCache(CacheLoader<K, V> loader, Duration duration) {
        return LoadingCachee.writeCache(loader, duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public static <K, V> LoadingCache<K, V> writeCache(CacheLoader<K, V> loader, long duration, TimeUnit unit) {
        return CacheBuilder.newBuilder().expireAfterWrite(duration, unit).build(loader);
    }

    public static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause();
        }
    }

    public static <K, V> V getUnchecked(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause();
        }
    }

    public static <K, V> ImmutableMap<K, V> getAll(LoadingCache<K, V> cache, Iterable<? extends K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause();
        }
    }
}

