/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.lang;

import com.github.charlemaznable.lang.Empty;
import com.github.charlemaznable.lang.joou.ULong;
import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;

public class Rand {
    private static final SecureRandom RANDOM = new SecureRandom();

    public static boolean randBoolean() {
        return RANDOM.nextBoolean();
    }

    public static double randDouble() {
        return RANDOM.nextDouble();
    }

    public static float randFloat() {
        return RANDOM.nextFloat();
    }

    public static int randInt() {
        return RANDOM.nextInt();
    }

    public static int randInt(int n) {
        return RANDOM.nextInt(n);
    }

    public static long randLong() {
        return RANDOM.nextLong();
    }

    public static String randNum(int count) {
        StringBuilder sb = new StringBuilder(count);
        while (sb.length() < count) {
            sb.append(new ULong(Rand.randLong()));
        }
        return sb.replace(count, sb.length(), "").toString();
    }

    public static String randAscii(int count) {
        return RandomStringUtils.random((int)count, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)RANDOM);
    }

    public static String randLetters(int count) {
        return RandomStringUtils.random((int)count, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)RANDOM);
    }

    public static String randAlphanumeric(int count) {
        return RandomStringUtils.random((int)count, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)RANDOM);
    }

    public static <T> T randWeighted(Map<T, Integer> weightedMap) {
        if (Empty.isEmpty(weightedMap)) {
            return null;
        }
        int sum = 1;
        for (Integer value : weightedMap.values()) {
            sum += value.intValue();
        }
        int rand = Rand.randInt(sum);
        for (Map.Entry<T, Integer> entry : weightedMap.entrySet()) {
            if ((rand -= entry.getValue().intValue()) > 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> T randInverseWeighted(Map<T, Integer> weightedMap) {
        if (Empty.isEmpty(weightedMap)) {
            return null;
        }
        int sum = 0;
        for (Integer value : weightedMap.values()) {
            sum += value.intValue();
        }
        HashMap inverseWeightedMap = Maps.newHashMap();
        for (Map.Entry<T, Integer> entry : weightedMap.entrySet()) {
            inverseWeightedMap.put(entry.getKey(), (int)(10.0 * (double)sum / Math.max(0.1, (double)entry.getValue().intValue())));
        }
        return Rand.randWeighted(inverseWeightedMap);
    }
}

