/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Str {
    public static final Pattern INTEGER_PATTERN = Pattern.compile("[-+]?([0-9]+)$");

    public static boolean isNull(String str) {
        return str == null;
    }

    public static boolean isNotNull(String str) {
        return str != null;
    }

    public static boolean isEmpty(String str) {
        return Str.isNull(str) || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return Str.isNotNull(str) && !str.isEmpty();
    }

    public static boolean isBlank(String str) {
        return Str.isEmpty(str) || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return Str.isNotEmpty(str) && !str.trim().isEmpty();
    }

    public static String padding(String s, char letter, int repeats) {
        StringBuilder sb = new StringBuilder(s);
        while (repeats-- > 0) {
            sb.append(letter);
        }
        return sb.toString();
    }

    public static String removeLastLetters(String s, char letter) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.charAt(sb.length() - 1) == letter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean matches(char left, char right) {
        if (left == '(') {
            return right == ')';
        }
        if (left == '[') {
            return right == ']';
        }
        return left == '{' && right == '}';
    }

    public static String substrInQuotes(String str, char left, int pos) {
        int leftTimes = 0;
        int leftPos = str.indexOf(left, pos);
        if (leftPos < 0) {
            return "";
        }
        for (int i = leftPos + 1; i < str.length(); ++i) {
            char charAt = str.charAt(i);
            if (charAt == left) {
                ++leftTimes;
                continue;
            }
            if (!Str.matches(left, charAt)) continue;
            if (leftTimes == 0) {
                return str.substring(leftPos + 1, i);
            }
            --leftTimes;
        }
        return "";
    }

    public static String toStr(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static boolean isInteger(String string) {
        Matcher matcher = INTEGER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String number = matcher.group(1);
        String maxValue = "2147483647";
        return number.length() <= "2147483647".length() && Str.alignRight(number, "2147483647".length(), '0').compareTo("2147483647") <= 0;
    }

    public static boolean isLong(String string) {
        Matcher matcher = INTEGER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String number = matcher.group(1);
        String maxValue = "9223372036854775807";
        return number.length() <= "9223372036854775807".length() && Str.alignRight(number, "9223372036854775807".length(), '0').compareTo("9223372036854775807") <= 0;
    }

    public static String alignRight(CharSequence cs, int width, char c) {
        if (null == cs) {
            return null;
        }
        int len = cs.length();
        if (len >= width) {
            return cs.toString();
        }
        return StringUtils.repeat((char)c, (int)(width - len)) + cs;
    }
}

