/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.lang.concurrent;

import com.google.common.eventbus.AsyncEventBus;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class EventBusExecutor {
    private AsyncEventBus eventBus = new AsyncEventBus(this.eventBusIdentifier(), this.eventBusExecutor());
    private ScheduledThreadPoolExecutor executor;

    public EventBusExecutor() {
        this(null);
    }

    public EventBusExecutor(Object subscriber) {
        this.eventBus.register(null == subscriber ? this : subscriber);
        this.executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() + 1);
    }

    public void post(Object event) {
        this.post(event, 0L, TimeUnit.NANOSECONDS);
    }

    public void post(Object event, long delay, TimeUnit unit) {
        this.executor.schedule(() -> this.eventBus.post(event), delay, unit);
    }

    public String eventBusIdentifier() {
        return this.getClass().getName();
    }

    public abstract Executor eventBusExecutor();
}

