/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.lang.time;

import com.github.charlemaznable.lang.Condition;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatter {
    private SimpleDateFormat format;

    public DateFormatter(String pattern) {
        this.format = new SimpleDateFormat(pattern);
    }

    public String transToFormat(String dateString, String toPattern) {
        Date parsed = this.parse(dateString);
        if (null == parsed) {
            return null;
        }
        return new SimpleDateFormat(toPattern).format(this.parse(dateString));
    }

    public String transFromFormat(String dateString, String fromPattern) {
        try {
            return this.format(new SimpleDateFormat(fromPattern).parse(dateString));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String format(Date date) {
        return this.format.format(date);
    }

    public Date parse(String dateString) {
        try {
            return this.format.parse(dateString);
        }
        catch (Exception e) {
            return null;
        }
    }

    @CanIgnoreReturnValue
    public String checkFormatQuietly(String dateString) {
        try {
            Condition.checkNotNull(dateString);
            return dateString.equals(this.format.format(this.format.parse(dateString))) ? dateString : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @CanIgnoreReturnValue
    public String checkFormat(String dateString) {
        Condition.checkNotNull(dateString);
        return dateString.equals(this.format.format(this.format.parse(dateString))) ? dateString : null;
    }
}

