/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.spring;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="HttpServletRequestBodyReaderFilter", urlPatterns={"/*"})
public class HttpServletRequestBodyReaderFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpServletRequestBodyReaderFilter.class);

    public void init(FilterConfig filterConfig) {
        log.debug("HttpServletRequestBodyReaderFilter init...");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("HttpServletRequestBodyReaderFilter doFilter...");
        chain.doFilter((ServletRequest)(request instanceof HttpServletRequest ? new HttpServletRequestBodyReaderWrapper((HttpServletRequest)request, "UTF-8") : request), response);
    }

    public void destroy() {
        log.debug("HttpServletRequestBodyReaderFilter destroy...");
    }

    static class HttpServletRequestBodyReaderWrapper
    extends HttpServletRequestWrapper {
        private final String body;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpServletRequestBodyReaderWrapper(HttpServletRequest request, String charsetName) {
            super(request);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charsetName));
            try {
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                this.body = stringBuilder.toString();
            }
            finally {
                if (Collections.singletonList(bufferedReader).get(0) != null) {
                    bufferedReader.close();
                }
            }
        }

        public ServletInputStream getInputStream() {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
            return new ServletInputStream(){

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() {
                    return byteArrayInputStream.read();
                }
            };
        }

        public BufferedReader getReader() {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public String getBody() {
            return this.body;
        }
    }
}

