/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.spring;

import com.github.charlemaznable.lang.Str;
import javax.annotation.Nonnull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static <T> T getBean(String beanName) {
        return SpringContext.getBean(beanName, null);
    }

    public static <T> T getBean(String beanName, T defaultValue) {
        if (applicationContext == null) {
            return defaultValue;
        }
        if (Str.isEmpty(beanName)) {
            return defaultValue;
        }
        try {
            return (T)applicationContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return defaultValue;
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        return SpringContext.getBean(clazz, null);
    }

    public static <T> T getBean(Class<T> clazz, T defaultValue) {
        if (applicationContext == null) {
            return defaultValue;
        }
        if (clazz == null) {
            return defaultValue;
        }
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return defaultValue;
        }
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        applicationContext = context;
    }
}

