/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.codec;

import com.github.charlemaznable.core.codec.Base64;
import com.github.charlemaznable.core.codec.Bytes;
import com.github.charlemaznable.core.codec.Hex;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;

public enum Digest {
    MD5{

        @Override
        protected Hasher digestHasher() {
            return Hashing.md5().newHasher();
        }
    }
    ,
    SHA1{

        @Override
        protected Hasher digestHasher() {
            return Hashing.sha1().newHasher();
        }
    }
    ,
    SHA256{

        @Override
        protected Hasher digestHasher() {
            return Hashing.sha256().newHasher();
        }
    }
    ,
    SHA384{

        @Override
        protected Hasher digestHasher() {
            return Hashing.sha384().newHasher();
        }
    }
    ,
    SHA512{

        @Override
        protected Hasher digestHasher() {
            return Hashing.sha512().newHasher();
        }
    };


    protected abstract Hasher digestHasher();

    public byte[] digest(byte[] info) {
        return this.digestHasher().putBytes(info).hash().asBytes();
    }

    public byte[] digest(String info) {
        return this.digest(Bytes.bytes(info));
    }

    public byte[] digest(byte[] info, byte[] salt) {
        return this.digestHasher().putBytes(salt).putBytes(info).putBytes(salt).hash().asBytes();
    }

    public byte[] digest(byte[] info, String salt) {
        return this.digest(info, Bytes.bytes(salt));
    }

    public byte[] digest(String info, byte[] salt) {
        return this.digest(Bytes.bytes(info), salt);
    }

    public byte[] digest(String info, String salt) {
        return this.digest(Bytes.bytes(info), Bytes.bytes(salt));
    }

    public String digestBase64(byte[] info) {
        return Base64.base64(this.digest(info), Base64.Format.Standard);
    }

    public String digestBase64(String info) {
        return this.digestBase64(Bytes.bytes(info));
    }

    public String digestBase64(byte[] info, byte[] salt) {
        return Base64.base64(this.digest(info, salt), Base64.Format.Standard);
    }

    public String digestBase64(byte[] info, String salt) {
        return this.digestBase64(info, Bytes.bytes(salt));
    }

    public String digestBase64(String info, byte[] salt) {
        return this.digestBase64(Bytes.bytes(info), salt);
    }

    public String digestBase64(String info, String salt) {
        return this.digestBase64(Bytes.bytes(info), Bytes.bytes(salt));
    }

    public String digestHex(byte[] info) {
        return Hex.hex(this.digest(info));
    }

    public String digestHex(String info) {
        return this.digestHex(Bytes.bytes(info));
    }

    public String digestHex(byte[] info, byte[] salt) {
        return Hex.hex(this.digest(info, salt));
    }

    public String digestHex(byte[] info, String salt) {
        return this.digestHex(info, Bytes.bytes(salt));
    }

    public String digestHex(String info, byte[] salt) {
        return this.digestHex(Bytes.bytes(info), salt);
    }

    public String digestHex(String info, String salt) {
        return this.digestHex(Bytes.bytes(info), Bytes.bytes(salt));
    }

    @Deprecated
    public byte[] digestDeprecated(String info) {
        return this.digestHasher().putUnencodedChars((CharSequence)info).hash().asBytes();
    }

    @Deprecated
    public byte[] digestDeprecated(String info, String salt) {
        return this.digestHasher().putUnencodedChars((CharSequence)salt).putUnencodedChars((CharSequence)info).putUnencodedChars((CharSequence)salt).hash().asBytes();
    }

    @Deprecated
    public String digestBase64Deprecated(String info) {
        return Base64.base64(this.digestDeprecated(info), Base64.Format.Standard);
    }

    @Deprecated
    public String digestBase64Deprecated(String info, String salt) {
        return Base64.base64(this.digestDeprecated(info, salt), Base64.Format.Standard);
    }

    @Deprecated
    public String digestHexDeprecated(String info) {
        return Hex.hex(this.digestDeprecated(info));
    }

    @Deprecated
    public String digestHexDeprecated(String info, String salt) {
        return Hex.hex(this.digestDeprecated(info, salt));
    }
}

