/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.codec;

import com.github.charlemaznable.core.codec.Base64;
import com.github.charlemaznable.core.codec.Bytes;
import com.github.charlemaznable.core.codec.Hex;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.security.Key;

public enum DigestHMAC {
    MD5{

        @Override
        protected Hasher digestHasher(Key key) {
            return Hashing.hmacMd5((Key)key).newHasher();
        }

        @Override
        protected Hasher digestHasher(byte[] key) {
            return Hashing.hmacMd5((byte[])key).newHasher();
        }
    }
    ,
    SHA1{

        @Override
        protected Hasher digestHasher(Key key) {
            return Hashing.hmacSha1((Key)key).newHasher();
        }

        @Override
        protected Hasher digestHasher(byte[] key) {
            return Hashing.hmacSha1((byte[])key).newHasher();
        }
    }
    ,
    SHA256{

        @Override
        protected Hasher digestHasher(Key key) {
            return Hashing.hmacSha256((Key)key).newHasher();
        }

        @Override
        protected Hasher digestHasher(byte[] key) {
            return Hashing.hmacSha256((byte[])key).newHasher();
        }
    }
    ,
    SHA512{

        @Override
        protected Hasher digestHasher(Key key) {
            return Hashing.hmacSha512((Key)key).newHasher();
        }

        @Override
        protected Hasher digestHasher(byte[] key) {
            return Hashing.hmacSha512((byte[])key).newHasher();
        }
    };


    protected abstract Hasher digestHasher(Key var1);

    protected abstract Hasher digestHasher(byte[] var1);

    protected Hasher digestHasher(String key) {
        return this.digestHasher(Bytes.bytes(key));
    }

    public byte[] digest(byte[] info, Key key) {
        return this.digestHasher(key).putBytes(info).hash().asBytes();
    }

    public byte[] digest(byte[] info, byte[] key) {
        return this.digestHasher(key).putBytes(info).hash().asBytes();
    }

    public byte[] digest(byte[] info, String key) {
        return this.digestHasher(key).putBytes(info).hash().asBytes();
    }

    public byte[] digest(String info, Key key) {
        return this.digest(Bytes.bytes(info), key);
    }

    public byte[] digest(String info, byte[] key) {
        return this.digest(Bytes.bytes(info), key);
    }

    public byte[] digest(String info, String key) {
        return this.digest(Bytes.bytes(info), key);
    }

    public String digestBase64(byte[] info, Key key) {
        return Base64.base64(this.digest(info, key), Base64.Format.Standard);
    }

    public String digestBase64(byte[] info, byte[] key) {
        return Base64.base64(this.digest(info, key), Base64.Format.Standard);
    }

    public String digestBase64(byte[] info, String key) {
        return Base64.base64(this.digest(info, key), Base64.Format.Standard);
    }

    public String digestBase64(String info, Key key) {
        return this.digestBase64(Bytes.bytes(info), key);
    }

    public String digestBase64(String info, byte[] key) {
        return this.digestBase64(Bytes.bytes(info), key);
    }

    public String digestBase64(String info, String key) {
        return this.digestBase64(Bytes.bytes(info), key);
    }

    public String digestHex(byte[] info, Key key) {
        return Hex.hex(this.digest(info, key));
    }

    public String digestHex(byte[] info, byte[] key) {
        return Hex.hex(this.digest(info, key));
    }

    public String digestHex(byte[] info, String key) {
        return Hex.hex(this.digest(info, key));
    }

    public String digestHex(String info, Key key) {
        return this.digestHex(Bytes.bytes(info), key);
    }

    public String digestHex(String info, byte[] key) {
        return this.digestHex(Bytes.bytes(info), key);
    }

    public String digestHex(String info, String key) {
        return this.digestHex(Bytes.bytes(info), key);
    }
}

