/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.charlemaznable.core.lang.Empty;
import com.github.charlemaznable.core.lang.Iterablee;
import com.github.charlemaznable.core.lang.Mapp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class Json {
    public static String jsonWithType(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
    }

    public static <T> T unJsonWithType(String json) {
        return (T)JSON.parse((String)json);
    }

    public static String jsonPretty(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public static String json(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String jsonOf(Object ... keyAndValues) {
        return JSON.toJSONString(Mapp.map(keyAndValues));
    }

    public static Map<String, Object> unJson(String json) {
        return JSON.parseObject((String)json);
    }

    public static <T> T unJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static List unJsonArray(String json) {
        return JSON.parseArray((String)json);
    }

    public static <T> List<T> unJsonArray(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    public static <K, V> Map<K, V> desc(Object obj) {
        return Json.unJson(Json.json(obj), Map.class);
    }

    public static <T> T spec(Map map, Class<T> clz) {
        return Json.unJson(Json.json(map), clz);
    }

    public static <T> T trans(Object obj, Class<T> clz) {
        return Json.unJson(Json.json(obj), clz);
    }

    public static Map<String, String> descFlat(Object obj) {
        HashMap<String, String> flat = Mapp.newHashMap();
        Map<String, Object> desc = Json.desc(obj);
        Json.flatMapping("", desc, flat);
        return flat;
    }

    private static void flatMapping(final String key, Map<String, Object> desc, final Map<String, String> target) {
        if (Empty.isEmpty(desc)) {
            return;
        }
        desc.forEach(new BiConsumer<String, Object>(){

            @Override
            public void accept(String k, Object v) {
                String mk = Json.mappingKey(key, k);
                if (v instanceof Map) {
                    Json.flatMapping(mk, (Map)v, target);
                } else if (v instanceof Collection) {
                    Collection collection = (Collection)v;
                    Iterablee.forEach(collection, (index, item) -> this.accept(mk + "[" + index + "]", item));
                } else {
                    target.put(mk, v.toString());
                }
            }
        });
    }

    private static String mappingKey(String superKey, String subKey) {
        return Empty.isEmpty(superKey) ? subKey : superKey + "." + subKey;
    }
}

