/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.codec;

import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.Mapp;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml {
    public static String xml(Map<String, Object> map) {
        return Xml.xml(map, "xml", false);
    }

    public static String xml(Map<String, Object> map, String rootName) {
        return Xml.xml(map, rootName, false);
    }

    public static String xml(Map<String, Object> map, boolean prettyFormat) {
        return Xml.xml(map, "xml", prettyFormat);
    }

    public static String xml(Map<String, Object> map, String rootName, boolean prettyFormat) {
        Element rootElement = DocumentHelper.createElement((String)rootName);
        Map2XmlString.map2Element(map, rootElement);
        return Map2XmlString.document2XmlString(DocumentHelper.createDocument((Element)rootElement), prettyFormat);
    }

    public static Map<String, Object> unXml(String text) {
        return Xml.unXml(text, new XmlParseFeature(), false);
    }

    public static Map<String, Object> unXml(String text, XmlParseFeature feature) {
        return Xml.unXml(text, feature, false);
    }

    public static Map<String, Object> unXml(String text, boolean rootAsTop) {
        return Xml.unXml(text, new XmlParseFeature(), rootAsTop);
    }

    public static Map<String, Object> unXml(String text, XmlParseFeature feature, boolean rootAsTop) {
        Document document = XmlString2Map.xmlString2Document(text, feature);
        Element rootElement = document.getRootElement();
        if (rootElement.elements().size() == 0 && rootElement.attributes().size() == 0) {
            return new LinkedHashMap<String, Object>();
        }
        Map<String, Map> map = XmlString2Map.element2Map(rootElement, false);
        return rootAsTop ? Mapp.of(rootElement.getName(), map) : map;
    }

    public static class XmlParseFeature {
        private static final String disallowDoctypeDeclName = "http://apache.org/map2Element/features/disallow-doctype-decl";
        private static final String loadExternalDTDName = "http://apache.org/map2Element/features/nonvalidating/load-external-dtd";
        private static final String externalGeneralEntitiesName = "http://map2Element.org/sax/features/external-general-entities";
        private static final String externalParameterEntitiesName = "http://map2Element.org/sax/features/external-parameter-entities";
        private boolean disallowDoctypeDecl = true;
        private boolean loadExternalDTD = false;
        private boolean externalGeneralEntities = false;
        private boolean externalParameterEntities = false;

        public void setSAXReaderFeatures(SAXReader reader) {
            try {
                reader.setFeature(disallowDoctypeDeclName, this.disallowDoctypeDecl);
                reader.setFeature(loadExternalDTDName, this.loadExternalDTD);
                reader.setFeature(externalGeneralEntitiesName, this.externalGeneralEntities);
                reader.setFeature(externalParameterEntitiesName, this.externalParameterEntities);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public boolean isDisallowDoctypeDecl() {
            return this.disallowDoctypeDecl;
        }

        public boolean isLoadExternalDTD() {
            return this.loadExternalDTD;
        }

        public boolean isExternalGeneralEntities() {
            return this.externalGeneralEntities;
        }

        public boolean isExternalParameterEntities() {
            return this.externalParameterEntities;
        }
    }

    private static class Map2XmlString {
        private Map2XmlString() {
        }

        private static String document2XmlString(Document document, boolean prettyFormat) {
            StringWriter writer = new StringWriter();
            OutputFormat format = prettyFormat ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            xmlWriter.close();
            return writer.toString();
        }

        private static void map2Element(Map<String, Object> map, Element body) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.startsWith("@")) {
                    body.addAttribute(key.substring(1, key.length()), value.toString());
                    continue;
                }
                if (key.equals("#text")) {
                    body.addCDATA(value.toString());
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object obj : list) {
                        if (obj instanceof Map) {
                            Element subElement = body.addElement(key);
                            Map2XmlString.map2Element((Map)obj, subElement);
                            continue;
                        }
                        body.addElement(key).addCDATA((String)obj);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    Element subElement = body.addElement(key);
                    Map2XmlString.map2Element((Map)value, subElement);
                    continue;
                }
                body.addElement(key).addCDATA(value.toString());
            }
        }
    }

    private static class XmlString2Map {
        private XmlString2Map() {
        }

        public static Document xmlString2Document(String text, XmlParseFeature feature) {
            SAXReader reader = new SAXReader();
            feature.setSAXReaderFeatures(reader);
            String encoding = XmlString2Map.getEncoding(text);
            InputSource source = new InputSource(new StringReader(text));
            source.setEncoding(encoding);
            Document result = reader.read(source);
            if (result.getXMLEncoding() == null) {
                result.setXMLEncoding(encoding);
            }
            return result;
        }

        private static String getEncoding(String text) {
            String result = null;
            String xml = text.trim();
            if (xml.startsWith("<?map2Element")) {
                int end = xml.indexOf("?>");
                String sub = xml.substring(0, end);
                StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (!"encoding".equals(token)) continue;
                    if (!tokens.hasMoreTokens()) break;
                    result = tokens.nextToken();
                    break;
                }
            }
            return result;
        }

        private static Map<String, Object> element2Map(Element element, boolean parseAttr) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            List elements = element.elements();
            List attributes = null;
            if (parseAttr) {
                attributes = element.attributes();
                for (Attribute attribute : attributes) {
                    map.put("@" + attribute.getName(), attribute.getValue());
                }
            }
            if (elements.size() > 0) {
                for (Element elem : elements) {
                    List attrs;
                    List mapList = Listt.newArrayList();
                    if (elem.elements().size() > 0) {
                        Map<String, Object> m = XmlString2Map.element2Map(elem, parseAttr);
                        if (map.get(elem.getName()) != null) {
                            Object obj = map.get(elem.getName());
                            if (!(obj instanceof List)) {
                                mapList = Listt.newArrayList();
                                mapList.add(obj);
                                mapList.add(m);
                            }
                            if (obj instanceof List) {
                                mapList = (List)obj;
                                mapList.add(m);
                            }
                            map.put(elem.getName(), mapList);
                            continue;
                        }
                        map.put(elem.getName(), m);
                        continue;
                    }
                    boolean hasAttributes = false;
                    LinkedHashMap<String, String> attributesMap = null;
                    if (parseAttr && (attrs = elem.attributes()).size() > 0) {
                        hasAttributes = true;
                        attributesMap = new LinkedHashMap<String, String>();
                        for (Attribute attr : attrs) {
                            attributesMap.put("@" + attr.getName(), attr.getValue());
                        }
                    }
                    if (map.get(elem.getName()) != null) {
                        Object obj = map.get(elem.getName());
                        if (!(obj instanceof List)) {
                            mapList = Listt.newArrayList();
                            mapList.add(obj);
                            if (parseAttr && hasAttributes) {
                                attributesMap.put("#text", elem.getText());
                                mapList.add(attributesMap);
                            } else {
                                mapList.add(elem.getText());
                            }
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            if (parseAttr && hasAttributes) {
                                attributesMap.put("#text", elem.getText());
                                mapList.add(attributesMap);
                            } else {
                                mapList.add(elem.getText());
                            }
                        }
                        map.put(elem.getName(), mapList);
                        continue;
                    }
                    if (parseAttr && hasAttributes) {
                        attributesMap.put("#text", elem.getText());
                        map.put(elem.getName(), attributesMap);
                        continue;
                    }
                    map.put(elem.getName(), elem.getText());
                }
            } else if (Listt.isNotEmpty(attributes)) {
                map.put("#text", element.getText());
            } else {
                map.put(element.getName(), element.getText());
            }
            return map;
        }
    }
}

