/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.config.impl;

import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.core.lang.Mapp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IniReader {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:(";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String QUOTE_CHARACTERS = "\"'";
    private static final String LINE_CONT = "\\";
    private Map<String, Properties> properties = Mapp.newHashMap();
    private List<String> sections = Listt.newArrayList();
    private int lineNumber;

    public IniReader(Reader reader) throws IOException {
        this.sections.add("");
        BufferedReader bufferedReader = new BufferedReader(reader);
        String line = bufferedReader.readLine();
        while (line != null) {
            ++this.lineNumber;
            if (!this.isCommentLine(line = line.trim())) {
                if (this.isSectionLine(line)) {
                    String section = line.substring(1, line.length() - 1).trim();
                    if (!this.sections.contains(section)) {
                        this.sections.add(section);
                    }
                } else {
                    String key;
                    String value = "";
                    int index = IniReader.findSeparator(line);
                    if (index >= 0) {
                        key = line.substring(0, index);
                        value = IniReader.parseValue(line.substring(index + 1), bufferedReader);
                        if (line.charAt(index) == '(' && value.charAt(value.length() - 1) == ')') {
                            value = value.substring(0, value.length() - 1);
                        }
                    } else {
                        key = line;
                    }
                    if ((key = key.trim()).length() < 1) {
                        key = " ";
                    }
                    this.createValueNodes(key, value);
                }
            }
            line = bufferedReader.readLine();
        }
    }

    private static String parseValue(String val, BufferedReader reader) throws IOException {
        boolean lineContinues;
        StringBuilder propertyValue = new StringBuilder();
        String value = val.trim();
        do {
            int i;
            boolean quoted = value.startsWith("\"") || value.startsWith("'");
            boolean stop = false;
            boolean escape = false;
            char quote = quoted ? value.charAt(0) : (char)'\u0000';
            StringBuilder result = new StringBuilder();
            int lastChar = 0;
            for (i = quoted ? 1 : 0; i < value.length() && !stop; ++i) {
                char c = value.charAt(i);
                if (quoted) {
                    if ('\\' == c && !escape) {
                        escape = true;
                    } else if (!escape && quote == c) {
                        stop = true;
                    } else if (escape && quote == c) {
                        escape = false;
                        result.append(c);
                    } else {
                        if (escape) {
                            escape = false;
                            result.append('\\');
                        }
                        result.append(c);
                    }
                } else if (IniReader.isCommentChar(c) && Character.isWhitespace(lastChar)) {
                    stop = true;
                } else {
                    result.append(c);
                }
                lastChar = c;
            }
            String v = result.toString();
            if (!quoted) {
                lineContinues = IniReader.lineContinues(v = v.trim());
                if (lineContinues) {
                    v = v.substring(0, v.length() - 1).trim();
                }
            } else {
                lineContinues = IniReader.lineContinues(value, i);
            }
            propertyValue.append(v);
            if (!lineContinues) continue;
            propertyValue.append(LINE_SEPARATOR);
            value = reader.readLine();
        } while (lineContinues && value != null);
        return propertyValue.toString();
    }

    private static boolean lineContinues(String line) {
        String s = line.trim();
        return s.equals(LINE_CONT) || s.length() > 2 && s.endsWith(LINE_CONT) && Character.isWhitespace(s.charAt(s.length() - 2));
    }

    private static boolean lineContinues(String line, int pos) {
        String s;
        if (pos >= line.length()) {
            s = line;
        } else {
            int end;
            for (end = pos; end < line.length() && !IniReader.isCommentChar(line.charAt(end)); ++end) {
            }
            s = line.substring(pos, end);
        }
        return IniReader.lineContinues(s);
    }

    private static boolean isCommentChar(char c) {
        return COMMENT_CHARS.indexOf(c) >= 0;
    }

    private static int findSeparator(String line) {
        int index1 = IniReader.findSeparatorBeforeQuote(line, IniReader.findFirstOccurrence(line, QUOTE_CHARACTERS));
        int index2 = IniReader.findFirstOccurrence(line, SEPARATOR_CHARS);
        if (index1 < 0) {
            index1 = index2;
        }
        return index1 < index2 ? index1 : index2;
    }

    private static int findFirstOccurrence(String line, String separators) {
        int index = -1;
        for (int i = 0; i < separators.length(); ++i) {
            char sep = separators.charAt(i);
            int pos = line.indexOf(sep);
            if (pos < 0 || index >= 0 && pos >= index) continue;
            index = pos;
        }
        return index;
    }

    private static int findSeparatorBeforeQuote(String line, int quoteIndex) {
        int index;
        for (index = quoteIndex - 1; index >= 0 && Character.isWhitespace(line.charAt(index)); --index) {
        }
        if (index >= 0 && SEPARATOR_CHARS.indexOf(line.charAt(index)) < 0) {
            index = -1;
        }
        return index;
    }

    private void createValueNodes(String key, String value) {
        String lastSection = this.sections.get(this.sections.size() - 1);
        Properties sectionProps = this.properties.get(lastSection);
        if (sectionProps == null) {
            sectionProps = new Properties();
            this.properties.put(lastSection, sectionProps);
        } else {
            String oldValue = (String)sectionProps.get(key);
            if (oldValue != null) {
                this.putIncKeyAndValue(sectionProps, key, oldValue);
            }
        }
        sectionProps.put(key, value.trim());
    }

    private void putIncKeyAndValue(Properties props, String key, String oldValue) {
        int seq = 0;
        while (props.containsKey(key + "." + seq)) {
            ++seq;
        }
        props.put(key + "." + seq, oldValue);
    }

    protected boolean isCommentLine(String line) {
        if (line == null) {
            return false;
        }
        return line.length() < 1 || COMMENT_CHARS.indexOf(line.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String line) {
        return line != null && line.startsWith("[") && line.endsWith("]");
    }

    public List<String> getSections() {
        return this.sections;
    }

    public Properties getSection(String name) {
        if (name == null) {
            return this.properties.get("");
        }
        return this.properties.get(name);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

