/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.config.impl;

import com.github.charlemaznable.core.config.ex.ConfigException;
import com.github.charlemaznable.core.config.impl.DefaultConfigable;
import com.github.charlemaznable.core.config.impl.PropsReader;
import com.github.charlemaznable.core.lang.ClzPath;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;

public class PropsConfigable
extends DefaultConfigable {
    public PropsConfigable(URL url) {
        super(PropsConfigable.buildProperties(url));
    }

    private static Properties buildProperties(URL url) {
        Object propertyName;
        PropsReader reader = null;
        Properties props = new Properties();
        try {
            reader = new PropsReader(new InputStreamReader(Objects.requireNonNull(ClzPath.urlAsInputStream(url)), Charsets.UTF_8));
            while (reader.nextProperty()) {
                propertyName = reader.getPropertyName();
                if (props.containsKey(propertyName)) {
                    throw new ConfigException("duplicate key [" + (String)propertyName + "] in file...");
                }
                props.put(propertyName, reader.getPropertyValue());
            }
            propertyName = props;
        }
        catch (IOException ex) {
            try {
                throw new ConfigException("read props file error: ", ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)reader);
        return propertyName;
    }
}

