/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.crypto;

import com.github.charlemaznable.core.codec.Base64;
import com.github.charlemaznable.core.codec.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSA {
    private static final String RSAKEY = "RSA";
    private static final String RSA = "RSA/ECB/PKCS1Padding";
    private static final int DEFAULT_KEY_SIZE = 1024;

    public static KeyPair generateKeyPair() {
        return com.github.charlemaznable.core.crypto.RSA.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keysize) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSAKEY);
        keyPairGenerator.initialize(keysize);
        return keyPairGenerator.generateKeyPair();
    }

    public static PublicKey getPublicKey(KeyPair keyPair) {
        return keyPair.getPublic();
    }

    public static String getPublicKeyString(KeyPair keyPair) {
        return com.github.charlemaznable.core.crypto.RSA.publicKeyString(com.github.charlemaznable.core.crypto.RSA.getPublicKey(keyPair));
    }

    public static PrivateKey getPrivateKey(KeyPair keyPair) {
        return keyPair.getPrivate();
    }

    public static String getPrivateKeyString(KeyPair keyPair) {
        return com.github.charlemaznable.core.crypto.RSA.privateKeyString(com.github.charlemaznable.core.crypto.RSA.getPrivateKey(keyPair));
    }

    public static PublicKey publicKey(String publicKeyString) {
        return KeyFactory.getInstance(RSAKEY).generatePublic(new X509EncodedKeySpec(Base64.unBase64(publicKeyString)));
    }

    public static String publicKeyString(PublicKey publicKey) {
        return Base64.base64(publicKey.getEncoded(), Base64.Format.Standard);
    }

    public static PrivateKey privateKey(String privateKeyString) {
        return KeyFactory.getInstance(RSAKEY).generatePrivate(new PKCS8EncodedKeySpec(Base64.unBase64(privateKeyString)));
    }

    public static String privateKeyString(PrivateKey privateKey) {
        return Base64.base64(privateKey.getEncoded(), Base64.Format.Standard);
    }

    public static int publicKeySize(PublicKey publicKey) {
        return KeyFactory.getInstance(RSAKEY).getKeySpec(publicKey, RSAPublicKeySpec.class).getModulus().toString(2).length();
    }

    public static int privateKeySize(PrivateKey privateKey) {
        return KeyFactory.getInstance(RSAKEY).getKeySpec(privateKey, RSAPrivateKeySpec.class).getModulus().toString(2).length();
    }

    public static byte[] pubEncrypt(String plainText, PublicKey publicKey) {
        return com.github.charlemaznable.core.crypto.RSA.encrypt(publicKey, com.github.charlemaznable.core.crypto.RSA.publicKeySize(publicKey), plainText);
    }

    public static String prvDecrypt(byte[] cipherBytes, PrivateKey privateKey) {
        return com.github.charlemaznable.core.crypto.RSA.decrypt(privateKey, com.github.charlemaznable.core.crypto.RSA.privateKeySize(privateKey), cipherBytes);
    }

    public static byte[] prvEncrypt(String plainText, PrivateKey privateKey) {
        return com.github.charlemaznable.core.crypto.RSA.encrypt(privateKey, com.github.charlemaznable.core.crypto.RSA.privateKeySize(privateKey), plainText);
    }

    public static String pubDecrypt(byte[] cipherBytes, PublicKey publicKey) {
        return com.github.charlemaznable.core.crypto.RSA.decrypt(publicKey, com.github.charlemaznable.core.crypto.RSA.publicKeySize(publicKey), cipherBytes);
    }

    public static byte[] encrypt(Key key, int keySize, String plainText) {
        return com.github.charlemaznable.core.crypto.RSA.encryptByBlock(key, keySize, Bytes.bytes(plainText));
    }

    public static String decrypt(Key key, int keySize, byte[] cipherBytes) {
        return Bytes.string(com.github.charlemaznable.core.crypto.RSA.decryptByBlock(key, keySize, cipherBytes));
    }

    private static byte[] encryptByBlock(Key key, int keySize, byte[] data) {
        return com.github.charlemaznable.core.crypto.RSA.cryptByBlock(1, key, keySize, data);
    }

    private static byte[] decryptByBlock(Key key, int keySize, byte[] data) {
        return com.github.charlemaznable.core.crypto.RSA.cryptByBlock(2, key, keySize, data);
    }

    private static byte[] cryptByBlock(int mode, Key key, int keySize, byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(mode, key);
        int maxBlock = keySize / 8 - (1 == mode ? 11 : 0);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > maxBlock ? cipher.doFinal(data, offSet, maxBlock) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * maxBlock;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }
}

