/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.lang;

import com.github.charlemaznable.core.lang.Condition;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;
import org.joor.Reflect;

public class Clz {
    public static boolean isAssignable(Class<?> fromClass, Class<?> ... toClasses) {
        for (Class<?> toClass : toClasses) {
            if (!ClassUtils.isAssignable(fromClass, toClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return clazz.getMethod(methodName, new Class[0]);
    }

    public static Object invokeQuietly(Object target, Method method, Object ... args) {
        block3: {
            try {
                return method.invoke(target, args);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof RuntimeException)) break block3;
                throw (RuntimeException)e.getTargetException();
            }
        }
        return null;
    }

    public static Class<?>[] types(Object ... values) {
        if (values == null) {
            return new Class[0];
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Condition.checkNull(values[i], () -> NULL.class, Object::getClass);
        }
        return result;
    }

    public static boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            for (int i = 0; i < actualTypes.length; ++i) {
                Class<?> actualType = actualTypes[i];
                if (actualType == NULL.class || Reflect.wrapper(declaredTypes[i]).isAssignableFrom(Reflect.wrapper(actualType))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Class<?>[] getConstructorParameterTypes(Class<?> clazz, Object ... arguments) {
        Class<?>[] types = Clz.types(arguments);
        try {
            return clazz.getDeclaredConstructor(types).getParameterTypes();
        }
        catch (NoSuchMethodException e) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (!Clz.match(parameterTypes, types)) continue;
                return parameterTypes;
            }
            return null;
        }
    }

    private static class NULL {
        private NULL() {
        }
    }
}

