/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.lang;

import com.github.charlemaznable.core.lang.Str;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.joor.Reflect;

public class ClzPath {
    public static boolean classExists(String className) {
        try {
            Class.forName(className, false, ClzPath.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Class<?> findClass(String className) {
        if (Str.isEmpty(className)) {
            return null;
        }
        try {
            return Class.forName(className, false, ClzPath.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static <T> Class<T> tryLoadClass(String className) {
        if (Str.isEmpty(className)) {
            return null;
        }
        try {
            return ClzPath.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL classResource(String classPath) {
        return ClzPath.getClassLoader().getResource(classPath);
    }

    public static boolean classResourceExists(String classPath) {
        return ClzPath.classResource(classPath) != null;
    }

    public static InputStream classResourceAsInputStream(String classPath) {
        return ClzPath.getClassLoader().getResourceAsStream(classPath);
    }

    public static String classResourceAsString(String classPath) {
        return ClzPath.urlAsString(ClzPath.classResource(classPath));
    }

    public static List<String> classResourceAsLines(String classPath) {
        return ClzPath.urlAsLines(ClzPath.classResource(classPath));
    }

    public static InputStream urlAsInputStream(URL url) {
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String urlAsString(URL url) {
        try {
            return url != null ? Resources.toString((URL)url, (Charset)Charsets.UTF_8) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<String> urlAsLines(URL url) {
        try {
            return url != null ? Resources.readLines((URL)url, (Charset)Charsets.UTF_8) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL[] classResources(String basePath, String extension) {
        return ExtensionMatchClzResources.classResources(basePath, extension);
    }

    private static class ExtensionMatchVFVisitor
    implements InvocationHandler {
        private final String extension;
        private final String rootPath;
        private final Set<URL> resources = Sets.newLinkedHashSet();

        public ExtensionMatchVFVisitor(String rootPath, String extension) {
            this.extension = extension;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String methodName = method.getName();
            if (Object.class.equals(method.getDeclaringClass())) {
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
            } else {
                if ("getAttributes".equals(methodName)) {
                    return this.getAttributes();
                }
                if ("visit".equals(methodName)) {
                    this.visit(args[0]);
                    return null;
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        public void visit(Object vfsResource) {
            try {
                if (VfsFileDelegate.getPath(vfsResource).substring(this.rootPath.length()).endsWith(this.extension)) {
                    this.resources.add(VfsFileDelegate.getURL(vfsResource));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to obtain URL for file " + vfsResource, ex);
            }
        }

        public Object getAttributes() {
            return VfsFileDelegate.getVisitorAttribute();
        }

        public Set<URL> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            return "extension: " + this.extension + ", resources: " + this.resources;
        }
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<URL> findMatchingResources(URL rootResource, String extension) {
            Object root = VfsFileDelegate.getRoot(rootResource);
            ExtensionMatchVFVisitor visitor = new ExtensionMatchVFVisitor(VfsFileDelegate.getPath(root), extension);
            VfsFileDelegate.visit(root, visitor);
            return visitor.getResources();
        }
    }

    private static class VfsFileDelegate {
        private static final String VFS3_PKG = "org.jboss.vfs.";

        private VfsFileDelegate() {
        }

        public static File getFile(URL url) {
            return VfsFileDelegate.getFile(VfsFileDelegate.getRoot(url));
        }

        public static Object getRoot(URL url) {
            return Reflect.onClass((String)"org.jboss.vfs.VFS").call("getChild", new Object[]{url}).get();
        }

        public static URL getURL(Object vfsResource) {
            return (URL)Reflect.on((Object)vfsResource).call("toURL").get();
        }

        public static File getFile(Object vfsResource) {
            return (File)Reflect.on((Object)vfsResource).call("getPhysicalFile").get();
        }

        public static String getPath(Object vfsResource) {
            return (String)Reflect.on((Object)vfsResource).call("getPathName").get();
        }

        public static Object getVisitorAttribute() {
            return Reflect.onClass((String)"org.jboss.vfs.VisitorAttributes").field("RECURSE").get();
        }

        public static void visit(Object resource, InvocationHandler visitor) {
            Reflect.on((Object)resource).call("visit", new Object[]{Proxy.newProxyInstance(ClzPath.getClassLoader(), new Class[]{VfsFileDelegate.getVirtualFileVisitor()}, visitor)});
        }

        private static Class<?> getVirtualFileVisitor() {
            return (Class)Reflect.onClass((String)"org.jboss.vfs.VirtualFileVisitor").get();
        }
    }

    private static class ExtensionMatchClzResources {
        public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
        private static final String FILE_URL_PREFIX = "file:";
        private static final String JAR_URL_PREFIX = "jar:";
        private static final String URL_PROTOCOL_FILE = "file";
        private static final String URL_PROTOCOL_JAR = "jar";
        private static final String URL_PROTOCOL_ZIP = "zip";
        private static final String URL_PROTOCOL_WSJAR = "wsjar";
        private static final String URL_PROTOCOL_VFSZIP = "vfszip";
        private static final String URL_PROTOCOL_VFS = "vfs";
        private static final String JAR_FILE_EXTENSION = ".jar";
        private static final String JAR_URL_SEPARATOR = "!/";
        private static boolean equinoxResolveMethodExists = ClzPath.classExists("org.eclipse.core.runtime.FileLocator");

        private ExtensionMatchClzResources() {
        }

        public static URL[] classResources(String basePath, String extension) throws IOException {
            String base = ExtensionMatchClzResources.resolveBasePath(basePath);
            String extn = ExtensionMatchClzResources.resolveExtension(extension);
            URL[] rootDirResources = ExtensionMatchClzResources.findRootClassResources(base);
            LinkedHashSet<URL> result = new LinkedHashSet<URL>(16);
            for (URL rootDirResource : rootDirResources) {
                if ((rootDirResource = ExtensionMatchClzResources.resolveRootDirResource(rootDirResource)).getProtocol().startsWith(URL_PROTOCOL_VFS)) {
                    result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirResource, extension));
                    continue;
                }
                if (ExtensionMatchClzResources.isJarResource(rootDirResource)) {
                    result.addAll(ExtensionMatchClzResources.findExtMatchingJarResources(rootDirResource, extn));
                    continue;
                }
                result.addAll(ExtensionMatchClzResources.findExtMatchingFileResources(rootDirResource, extn));
            }
            return result.toArray(new URL[result.size()]);
        }

        public static boolean isReadable(URL url) {
            try {
                String protocol = url.getProtocol();
                if (URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol)) {
                    File file = ExtensionMatchClzResources.getFile(url);
                    return file.canRead() && !file.isDirectory();
                }
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }

        private static String resolveBasePath(String basePath) {
            if (Str.isEmpty(basePath)) {
                return Str.toStr(basePath);
            }
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            return basePath;
        }

        private static String resolveExtension(String extension) {
            if (Str.isEmpty(extension)) {
                return Str.toStr(extension);
            }
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            return extension;
        }

        private static URL[] findRootClassResources(String basePath) throws IOException {
            Enumeration<URL> urlEnumer;
            LinkedHashSet<URL> result = new LinkedHashSet<URL>(16);
            ClassLoader classLoader = ClzPath.getClassLoader();
            Enumeration<URL> enumeration = urlEnumer = classLoader != null ? classLoader.getResources(basePath) : ClassLoader.getSystemResources(basePath);
            while (urlEnumer.hasMoreElements()) {
                result.add(urlEnumer.nextElement());
            }
            if ("".equals(basePath)) {
                ExtensionMatchClzResources.addAllClassLoaderJarRoots(classLoader, result);
            }
            return result.toArray(new URL[result.size()]);
        }

        private static void addAllClassLoaderJarRoots(ClassLoader classLoader, Set<URL> result) {
            if (classLoader instanceof URLClassLoader) {
                try {
                    URL[] urls;
                    for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                        URL newURL;
                        if (!ExtensionMatchClzResources.isJarFileURL(url) || !ExtensionMatchClzResources.existsJarFileURL(newURL = new URL(JAR_URL_PREFIX + url.toString() + JAR_URL_SEPARATOR))) continue;
                        result.add(newURL);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (classLoader != null) {
                try {
                    ExtensionMatchClzResources.addAllClassLoaderJarRoots(classLoader.getParent(), result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static boolean isJarFileURL(URL url) {
            return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
        }

        private static boolean existsJarFileURL(URL url) {
            try {
                HttpURLConnection httpCon;
                URLConnection con = url.openConnection();
                ExtensionMatchClzResources.customizeConnection(con);
                HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
                if (httpCon != null) {
                    int code = httpCon.getResponseCode();
                    if (code == 200) {
                        return true;
                    }
                    if (code == 404) {
                        return false;
                    }
                }
                if (con.getContentLength() >= 0) {
                    return true;
                }
                if (httpCon != null) {
                    httpCon.disconnect();
                    return false;
                }
                InputStream is = ExtensionMatchClzResources.getInputStream(url);
                is.close();
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }

        private static void customizeConnection(URLConnection con) throws IOException {
            ExtensionMatchClzResources.useCachesIfNecessary(con);
            if (con instanceof HttpURLConnection) {
                ExtensionMatchClzResources.customizeConnection((HttpURLConnection)con);
            }
        }

        private static void useCachesIfNecessary(URLConnection con) {
            con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
        }

        private static void customizeConnection(HttpURLConnection con) throws IOException {
            con.setRequestMethod("HEAD");
        }

        private static InputStream getInputStream(URL url) throws IOException {
            URLConnection con = url.openConnection();
            ExtensionMatchClzResources.useCachesIfNecessary(con);
            try {
                return con.getInputStream();
            }
            catch (IOException ex) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw ex;
            }
        }

        private static URL resolveRootDirResource(URL original) {
            if (equinoxResolveMethodExists && original.getProtocol().startsWith("bundle")) {
                return (URL)Reflect.onClass((String)"org.eclipse.core.runtime.FileLocator").call("resolve", new Object[]{original}).get();
            }
            return original;
        }

        private static boolean isJarResource(URL url) {
            String protocol = url.getProtocol();
            return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Set<URL> findExtMatchingJarResources(URL rootDirResource, String extension) throws IOException {
            String rootEntryPath;
            JarFile jarFile;
            URLConnection con = rootDirResource.openConnection();
            boolean newJarFile = false;
            if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                ExtensionMatchClzResources.useCachesIfNecessary(jarCon);
                jarFile = jarCon.getJarFile();
                JarEntry jarEntry = jarCon.getJarEntry();
                rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
            } else {
                String urlFile = rootDirResource.getFile();
                int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
                if (separatorIndex != -1) {
                    rootEntryPath = urlFile.substring(separatorIndex + JAR_URL_SEPARATOR.length());
                    jarFile = ExtensionMatchClzResources.getJarFile(urlFile.substring(0, separatorIndex));
                } else {
                    jarFile = new JarFile(urlFile);
                    rootEntryPath = "";
                }
                newJarFile = true;
            }
            try {
                if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                    rootEntryPath = rootEntryPath + "/";
                }
                LinkedHashSet<URL> result = new LinkedHashSet<URL>(8);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryPath = entry.getName();
                    if (!entryPath.startsWith(rootEntryPath) || !entryPath.endsWith(extension)) continue;
                    String relativePath = entryPath.substring(rootEntryPath.length());
                    if (relativePath.startsWith("/")) {
                        relativePath = relativePath.substring(1);
                    }
                    result.add(new URL(rootDirResource, relativePath));
                }
                LinkedHashSet<URL> linkedHashSet = result;
                return linkedHashSet;
            }
            finally {
                if (newJarFile) {
                    jarFile.close();
                }
            }
        }

        private static JarFile getJarFile(String jarFileUrl) throws IOException {
            if (jarFileUrl.startsWith(FILE_URL_PREFIX)) {
                try {
                    return new JarFile(ExtensionMatchClzResources.toURI(jarFileUrl).getSchemeSpecificPart());
                }
                catch (URISyntaxException ex) {
                    return new JarFile(jarFileUrl.substring(FILE_URL_PREFIX.length()));
                }
            }
            return new JarFile(jarFileUrl);
        }

        private static URI toURI(String location) throws URISyntaxException {
            return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
        }

        private static Set<URL> findExtMatchingFileResources(URL rootDirResource, String extension) throws IOException {
            File rootDir;
            try {
                rootDir = ExtensionMatchClzResources.getFile(rootDirResource).getAbsoluteFile();
            }
            catch (IOException ex) {
                return Collections.emptySet();
            }
            return ExtensionMatchClzResources.doFindMatchingFileSystemResources(rootDir, extension);
        }

        private static File getFile(URL url) throws IOException {
            if (url.getProtocol().startsWith(URL_PROTOCOL_VFS)) {
                return VfsFileDelegate.getFile(url);
            }
            if (!URL_PROTOCOL_FILE.equals(url.getProtocol())) {
                throw new FileNotFoundException("URL [" + url + "] cannot be resolved to absolute file path because it does not reside in the file system: " + url);
            }
            try {
                return new File(ExtensionMatchClzResources.toURI(url.toString()).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new File(url.getFile());
            }
        }

        private static Set<URL> doFindMatchingFileSystemResources(File rootDir, String extension) throws IOException {
            Set<File> matchingFiles = ExtensionMatchClzResources.retrieveMatchingFiles(rootDir, extension);
            LinkedHashSet<URL> result = new LinkedHashSet<URL>(matchingFiles.size());
            for (File file : matchingFiles) {
                result.add(file.toURI().toURL());
            }
            return result;
        }

        private static Set<File> retrieveMatchingFiles(File rootDir, String extension) {
            if (!(rootDir.exists() && rootDir.isDirectory() && rootDir.canRead())) {
                return Collections.emptySet();
            }
            LinkedHashSet<File> result = new LinkedHashSet<File>(8);
            ExtensionMatchClzResources.doRetrieveMatchingFiles(extension, rootDir, result);
            return result;
        }

        private static void doRetrieveMatchingFiles(String extension, File dir, Set<File> result) {
            File[] dirContents = dir.listFiles();
            if (dirContents == null) {
                return;
            }
            String abnormalPattern = File.separator + extension;
            for (File content : dirContents) {
                String currPath = StringUtils.replace((String)content.getAbsolutePath(), (String)File.separator, (String)"/");
                if (content.isDirectory() && content.canRead()) {
                    ExtensionMatchClzResources.doRetrieveMatchingFiles(extension, content, result);
                    continue;
                }
                if (!currPath.endsWith(extension) || currPath.endsWith(abnormalPattern)) continue;
                result.add(content);
            }
        }
    }
}

