/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Str {
    public static final Pattern INTEGER_PATTERN = Pattern.compile("[-+]?([0-9]+)$");

    public static boolean isNull(String str) {
        return str == null;
    }

    public static boolean isNotNull(String str) {
        return str != null;
    }

    public static boolean isEmpty(String str) {
        return Str.isNull(str) || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return Str.isNotNull(str) && !str.isEmpty();
    }

    public static boolean isBlank(String str) {
        return Str.isEmpty(str) || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return Str.isNotEmpty(str) && !str.trim().isEmpty();
    }

    public static String padding(String s, char letter, int repeats) {
        StringBuilder sb = new StringBuilder(s);
        while (repeats-- > 0) {
            sb.append(letter);
        }
        return sb.toString();
    }

    public static String removeLastLetters(String s, char letter) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.charAt(sb.length() - 1) == letter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean matches(char left, char right) {
        if (left == '(') {
            return right == ')';
        }
        if (left == '[') {
            return right == ']';
        }
        return left == '{' && right == '}';
    }

    public static String substrInQuotes(String str, char left, int pos) {
        int leftTimes = 0;
        int leftPos = str.indexOf(left, pos);
        if (leftPos < 0) {
            return "";
        }
        for (int i = leftPos + 1; i < str.length(); ++i) {
            char charAt = str.charAt(i);
            if (charAt == left) {
                ++leftTimes;
                continue;
            }
            if (!Str.matches(left, charAt)) continue;
            if (leftTimes == 0) {
                return str.substring(leftPos + 1, i);
            }
            --leftTimes;
        }
        return "";
    }

    public static String toStr(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static boolean isInteger(String string) {
        Matcher matcher = INTEGER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String number = matcher.group(1);
        String maxValue = "2147483647";
        return number.length() <= "2147483647".length() && Str.alignRight(number, "2147483647".length(), '0').compareTo("2147483647") <= 0;
    }

    public static boolean isLong(String string) {
        Matcher matcher = INTEGER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String number = matcher.group(1);
        String maxValue = "9223372036854775807";
        return number.length() <= "9223372036854775807".length() && Str.alignRight(number, "9223372036854775807".length(), '0').compareTo("9223372036854775807") <= 0;
    }

    public static String alignRight(CharSequence cs, int width, char c) {
        if (null == cs) {
            return null;
        }
        int len = cs.length();
        if (len >= width) {
            return cs.toString();
        }
        return StringUtils.repeat((char)c, (int)(width - len)) + cs;
    }

    public static Integer intOf(String str) {
        return Str.intOf(str, 0);
    }

    public static Integer intOf(String str, Integer defaultValue) {
        return Str.intOf(str, 10, defaultValue);
    }

    public static Integer intOf(String str, int radix, Integer defaultValue) {
        try {
            return Integer.parseInt(str, radix);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Long longOf(String str) {
        return Str.longOf(str, 0L);
    }

    public static Long longOf(String str, Long defaultValue) {
        return Str.longOf(str, 10, 0L);
    }

    public static Long longOf(String str, int radix, Long defaultValue) {
        try {
            return Long.parseLong(str, radix);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Short shortOf(String str) {
        return Str.shortOf(str, (short)0);
    }

    public static Short shortOf(String str, Short defaultValue) {
        return Str.shortOf(str, 10, (short)0);
    }

    public static Short shortOf(String str, int radix, Short defaultValue) {
        try {
            return Short.parseShort(str, radix);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Float floatOf(String str) {
        return Str.floatOf(str, Float.valueOf(0.0f));
    }

    public static Float floatOf(String str, Float defaultValue) {
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Double doubleOf(String str) {
        return Str.doubleOf(str, 0.0);
    }

    public static Double doubleOf(String str, Double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean anyOfIgnoreCase(String s, String ... anys) {
        for (String any : anys) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)any)) continue;
            return true;
        }
        return false;
    }
}

