/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.lang.joou;

import com.github.charlemaznable.core.lang.joou.UNumber;

public final class UByte
extends UNumber
implements Comparable<UByte> {
    public static final short MIN_VALUE = 0;
    public static final short MAX_VALUE = 255;
    private static final long serialVersionUID = -6821055240959745390L;
    private final short value;

    public UByte(short value) throws NumberFormatException {
        this.value = value;
        this.rangeCheck();
    }

    public UByte(byte value) {
        this.value = (short)(value & 0xFF);
    }

    public UByte(String value) throws NumberFormatException {
        this.value = Short.parseShort(value);
        this.rangeCheck();
    }

    public static UByte valueOf(String value) throws NumberFormatException {
        return new UByte(value);
    }

    public static UByte valueOf(byte value) {
        return new UByte(value);
    }

    private void rangeCheck() throws NumberFormatException {
        if (this.value < 0 || this.value > 255) {
            throw new NumberFormatException("Value is out of range : " + this.value);
        }
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Short.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UByte && this.value == ((UByte)obj).value;
    }

    public String toString() {
        return Short.valueOf(this.value).toString();
    }

    @Override
    public int compareTo(UByte o) {
        return Short.compare(this.value, o.value);
    }
}

