/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.lang.pool;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.EasyEnhancer;
import com.github.charlemaznable.core.lang.pool.PooledObjectCreator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.NonNull;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class PoolProxy {
    public static <T> ObjectPoolBuilder<T> builder(@NonNull ObjectPool<T> pool) {
        if (pool == null) {
            throw new NullPointerException("pool is marked non-null but is null");
        }
        return new ObjectPoolBuilder<T>(pool);
    }

    public static <T> PooledObjectCreatorBuilder<T> builder(@NonNull PooledObjectCreator<T> creator) {
        if (creator == null) {
            throw new NullPointerException("creator is marked non-null but is null");
        }
        return new PooledObjectCreatorBuilder<T>(creator);
    }

    private static class PoolProxyPooledObjectFactory<T>
    extends BasePooledObjectFactory<T> {
        private PooledObjectCreator<T> pooledObjectCreator;
        private Object[] createArguments;

        public T create() throws Exception {
            return this.pooledObjectCreator.create(this.createArguments);
        }

        public PooledObject<T> wrap(T t) {
            return this.pooledObjectCreator.wrap(t);
        }

        public PoolProxyPooledObjectFactory(PooledObjectCreator<T> pooledObjectCreator, Object[] createArguments) {
            this.pooledObjectCreator = pooledObjectCreator;
            this.createArguments = createArguments;
        }
    }

    private static class ObjectPoolProxy<T>
    implements MethodInterceptor {
        private ObjectPool<T> pool;

        public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object poolObject = null;
            try {
                poolObject = this.pool.borrowObject();
                Object object = method.invoke(poolObject, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (poolObject != null) {
                    this.pool.returnObject(poolObject);
                }
            }
        }

        public ObjectPoolProxy(ObjectPool<T> pool) {
            this.pool = pool;
        }
    }

    public static class PooledObjectCreatorBuilder<T> {
        @NonNull
        private PooledObjectCreator<T> creator;
        private GenericObjectPoolConfig<T> config;
        private Object[] args = new Object[0];

        public PooledObjectCreatorBuilder<T> config(GenericObjectPoolConfig<T> config) {
            this.config = config;
            return this;
        }

        public PooledObjectCreatorBuilder<T> args(Object ... args) {
            this.args = args;
            return this;
        }

        public T build() {
            PoolProxyPooledObjectFactory<T> factory = new PoolProxyPooledObjectFactory<T>(this.creator, this.args);
            return new ObjectPoolBuilder(new GenericObjectPool(factory, Condition.nullThen(this.config, GenericObjectPoolConfig::new))).args(this.args).build();
        }

        public PooledObjectCreatorBuilder(@NonNull PooledObjectCreator<T> creator) {
            if (creator == null) {
                throw new NullPointerException("creator is marked non-null but is null");
            }
            this.creator = creator;
        }
    }

    public static class ObjectPoolBuilder<T> {
        @NonNull
        private ObjectPool<T> pool;
        private Object[] args = new Object[0];

        public ObjectPoolBuilder<T> args(Object ... args) {
            this.args = args;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T build() {
            Object poolObject = null;
            try {
                poolObject = this.pool.borrowObject();
                Class<?> poolObjectClass = poolObject.getClass();
                Object object = EasyEnhancer.create(poolObjectClass, new ObjectPoolProxy<T>(this.pool), this.args);
                return (T)object;
            }
            finally {
                if (poolObject != null) {
                    this.pool.returnObject(poolObject);
                }
            }
        }

        public ObjectPoolBuilder(@NonNull ObjectPool<T> pool) {
            if (pool == null) {
                throw new NullPointerException("pool is marked non-null but is null");
            }
            this.pool = pool;
        }
    }
}

