/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.miner;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.EasyEnhancer;
import com.github.charlemaznable.core.lang.Str;
import com.github.charlemaznable.core.miner.MinerConfig;
import com.github.charlemaznable.core.miner.MinerConfigException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.n3r.diamond.client.Miner;
import org.n3r.diamond.client.Minerable;
import org.n3r.diamond.client.impl.DiamondUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class MinerFactory {
    private static Cache<Class, Object> minerCache = CacheBuilder.newBuilder().build();

    public static <T> T getMiner(Class<T> minerClass) {
        MinerFactory.ensureClassIsAnInterface(minerClass);
        MinerConfig minerConfig = MinerFactory.checkMinerConfig(minerClass);
        return (T)minerCache.get(minerClass, () -> MinerFactory.loadMiner(minerClass, minerConfig));
    }

    private static <T> void ensureClassIsAnInterface(Class<T> clazz) {
        if (clazz.isInterface()) {
            return;
        }
        throw new MinerConfigException(clazz + " is not An Interface");
    }

    private static <T> MinerConfig checkMinerConfig(Class<T> clazz) {
        return (MinerConfig)Condition.checkNotNull(AnnotationUtils.findAnnotation(clazz, MinerConfig.class), new MinerConfigException(clazz + " has no MinerConfig"));
    }

    private static Object loadMiner(Class minerClass, MinerConfig minerConfig) {
        Miner minerable = new Miner(Condition.blankThen(minerConfig.group(), () -> "DEFAULT_GROUP"));
        String dataId = minerConfig.dataId();
        MinerProxy minerProxy = new MinerProxy((Minerable)(Str.isNotBlank(dataId) ? minerable.getMiner(dataId) : minerable));
        return EasyEnhancer.create(MinerObject.class, new Class[]{minerClass, Minerable.class}, method -> {
            if (method.isDefault()) {
                return 1;
            }
            return 0;
        }, new Callback[]{minerProxy, NoOp.INSTANCE}, null);
    }

    private static class MinerProxy
    implements MethodInterceptor {
        private Minerable minerable;

        public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (method.getDeclaringClass().equals(Minerable.class)) {
                return method.invoke((Object)this.minerable, args);
            }
            MinerConfig minerConfig = (MinerConfig)AnnotationUtils.findAnnotation((Method)method, MinerConfig.class);
            String group = null != minerConfig ? minerConfig.group() : "";
            String dataId = null != minerConfig ? minerConfig.dataId() : "";
            String defaultValue = null != minerConfig ? minerConfig.defaultValue() : null;
            Object defaultArgument = args.length > 0 ? args[0] : null;
            String stone = this.minerable.getStone(group, Condition.blankThen(dataId, method::getName));
            if (null != stone) {
                return this.convertType(stone, method);
            }
            if (null != defaultArgument) {
                return defaultArgument;
            }
            if (null != defaultValue) {
                return this.convertType(defaultValue, method);
            }
            return null;
        }

        private Object convertType(String value, Method method) {
            boolean isCollection;
            Class rt = Primitives.unwrap(method.getReturnType());
            if (rt == String.class) {
                return value;
            }
            if (rt.isPrimitive()) {
                return this.parsePrimitive(rt, value);
            }
            Type grt = method.getGenericReturnType();
            boolean bl = isCollection = grt instanceof ParameterizedType && Collection.class.isAssignableFrom(rt);
            if (!isCollection) {
                return this.parseObject(rt, value);
            }
            return this.parseObjects((Class)((ParameterizedType)grt).getActualTypeArguments()[0], value);
        }

        private Object parsePrimitive(Class<?> rt, String value) {
            if (rt == Boolean.TYPE) {
                return Str.anyOfIgnoreCase(value, "yes", "true", "on");
            }
            if (rt == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (rt == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (rt == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (rt == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (rt == Double.TYPE) {
                return Double.parseDouble(value);
            }
            if (rt == Byte.TYPE) {
                return Byte.parseByte(value);
            }
            return null;
        }

        private Object parseObject(Class<?> rt, String value) {
            return DiamondUtils.parseObject((String)value, rt);
        }

        private Object parseObjects(Class<?> rt, String value) {
            return DiamondUtils.parseObjects((String)value, rt);
        }

        public MinerProxy(Minerable minerable) {
            this.minerable = minerable;
        }
    }

    private static class MinerObject {
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinerObject)) {
                return false;
            }
            MinerObject other = (MinerObject)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof MinerObject;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "MinerFactory.MinerObject()";
        }
    }
}

