/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.net;

import com.github.charlemaznable.core.lang.Str;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerMapping;

public class Http {
    public static void responseJson(HttpServletResponse rsp, String json) {
        Http.responseContent(rsp, json, "application/json", "UTF-8");
    }

    public static void responseText(HttpServletResponse rsp, String text) {
        Http.responseContent(rsp, text, "text/plain", "UTF-8");
    }

    public static void responseHtml(HttpServletResponse rsp, String html) {
        Http.responseContent(rsp, html, "text/html", "UTF-8");
    }

    public static void responseContent(HttpServletResponse rsp, String content, String contentType, String characterEncoding) {
        if (content == null) {
            return;
        }
        rsp.setHeader("Content-Type", contentType + "; charset=" + characterEncoding);
        rsp.setCharacterEncoding(characterEncoding);
        PrintWriter writer = rsp.getWriter();
        writer.write(content);
        writer.flush();
    }

    public static Map<String, String> fetchParameterMap(HttpServletRequest request) {
        HashMap parameterMap = Maps.newHashMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            parameterMap.put(parameterName, request.getParameter(parameterName));
        }
        return parameterMap;
    }

    public static Map<String, String> fetchPathVariableMap(HttpServletRequest request) {
        HashMap pathVariableMap = Maps.newHashMap();
        Object pathVariables = request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (pathVariables != null) {
            pathVariableMap.putAll((Map)pathVariables);
        }
        return pathVariableMap;
    }

    public static String fetchRemoteAddr(HttpServletRequest request) {
        String proxyClientIP;
        String xForwardedFor = request.getHeader("x-forwarded-for");
        if (Str.isNotEmpty(xForwardedFor)) {
            List forwardedAddrList = Splitter.on((String)",").trimResults().splitToList((CharSequence)xForwardedFor);
            for (String forwardedAddr : forwardedAddrList) {
                if (!Str.isNotEmpty(forwardedAddr) || "unknown".equalsIgnoreCase(forwardedAddr)) continue;
                return forwardedAddr;
            }
        }
        if (Str.isNotEmpty(proxyClientIP = request.getHeader("Proxy-Client-IP")) && !"unknown".equalsIgnoreCase(proxyClientIP)) {
            return proxyClientIP;
        }
        String wlProxyClientIP = request.getHeader("WL-Proxy-Client-IP");
        if (Str.isNotEmpty(wlProxyClientIP) && !"unknown".equalsIgnoreCase(wlProxyClientIP)) {
            return wlProxyClientIP;
        }
        return request.getRemoteAddr();
    }

    public static Map<String, String> dealReqParams(Map<String, String[]> requestParams) {
        HashMap params = Maps.newHashMap();
        for (String key : requestParams.keySet()) {
            String[] values = requestParams.get(key);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            valueStr = new String(valueStr.getBytes(Charsets.ISO_8859_1), "gbk");
            params.put(key, valueStr);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dealRequestBody(HttpServletRequest req, String charsetName) {
        String string;
        block7: {
            DataInputStream dis = new DataInputStream((InputStream)req.getInputStream());
            try {
                int bytes;
                int formDataLength = req.getContentLength();
                byte[] buff = new byte[formDataLength];
                for (int totalBytes = 0; totalBytes < formDataLength; totalBytes += bytes) {
                    bytes = dis.read(buff, totalBytes, formDataLength);
                }
                string = new String(buff, charsetName);
                if (Collections.singletonList(dis).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(dis).get(0) != null) {
                    dis.close();
                }
                throw throwable;
            }
            dis.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dealRequestBodyStream(HttpServletRequest req, String charsetName) {
        String string;
        block7: {
            InputStreamReader isr = new InputStreamReader((InputStream)req.getInputStream(), charsetName);
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(isr);
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                string = stringBuilder.toString();
                if (Collections.singletonList(isr).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(isr).get(0) != null) {
                    isr.close();
                }
                throw throwable;
            }
            isr.close();
        }
        return string;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }

    public static void error(HttpServletResponse response, int statusCode, Throwable ex) {
        response.setStatus(statusCode);
        String message = ex.getMessage();
        Http.responseText(response, message != null ? message : ex.toString());
    }

    public static void errorJson(HttpServletResponse response, int statusCode, String json) {
        response.setStatus(statusCode);
        Http.responseJson(response, json);
    }

    public static void errorText(HttpServletResponse response, int statusCode, String text) {
        response.setStatus(statusCode);
        Http.responseText(response, text);
    }

    public static void errorHtml(HttpServletResponse response, int statusCode, String html) {
        response.setStatus(statusCode);
        Http.responseHtml(response, html);
    }
}

