/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public enum IP {
    V4{

        @Override
        protected boolean checkInetAddress(InetAddress inetAddress) {
            return inetAddress instanceof Inet4Address;
        }
    }
    ,
    V6{

        @Override
        protected boolean checkInetAddress(InetAddress inetAddress) {
            return inetAddress instanceof Inet6Address;
        }
    };


    protected abstract boolean checkInetAddress(InetAddress var1);

    public String localIP() {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || this.isReservedAddress(ip) || !this.checkInetAddress(ip)) continue;
                return this.filterAdapterName(ip.getHostAddress());
            }
        }
        return null;
    }

    public String netIP() {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (ip.isSiteLocalAddress() || this.isReservedAddress(ip) || !this.checkInetAddress(ip)) continue;
                return this.filterAdapterName(ip.getHostAddress());
            }
        }
        return this.localIP();
    }

    private boolean isReservedAddress(InetAddress inetAddress) {
        return inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress();
    }

    private String filterAdapterName(String hostAddress) {
        int index = hostAddress.indexOf(37);
        if (index > 0) {
            hostAddress = hostAddress.substring(0, index);
        }
        return hostAddress;
    }
}

