/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.spring;

import com.github.charlemaznable.core.lang.Clz;
import com.github.charlemaznable.core.lang.ClzPath;
import com.github.charlemaznable.core.lang.Listt;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class ClzResolver {
    private static final String PATTERN = "/**/*.class";

    public static List<Class<?>> getClasses(String basePackage, Predicate<Class<?>> classPredicate) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metaFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        Resource[] resources = resolver.getResources("classpath*:" + ClzResolver.resolveBasePackage(basePackage) + PATTERN);
        ArrayList<Class<?>> classes = Listt.newArrayList();
        for (Resource res : resources) {
            Class<?> clazz;
            if (!res.isReadable() || null == (clazz = ClzPath.findClass(metaFactory.getMetadataReader(res).getClassMetadata().getClassName())) || null != classPredicate && !classPredicate.test(clazz)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static List<Class<?>> getClasses(String basePackage) {
        return ClzResolver.getClasses(basePackage, null);
    }

    public static List<Class<?>> getSubClasses(String basePackage, Class<?> superClass) {
        return ClzResolver.getClasses(basePackage, clazz -> Clz.isAssignable(clazz, superClass) && !clazz.equals(superClass));
    }

    public static List<Class<?>> getAnnotatedClasses(String basePackage, Class<? extends Annotation> annoClass) {
        return ClzResolver.getClasses(basePackage, clazz -> clazz.isAnnotationPresent(annoClass));
    }

    private static String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }
}

