/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.spring;

import com.github.charlemaznable.core.codec.Bytes;
import com.github.charlemaznable.core.lang.Mapp;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MutableHttpServletRequest
extends HttpServletRequestWrapper {
    private Map<String, String[]> params;
    private String content;
    private Charset charset;

    public MutableHttpServletRequest(HttpServletRequest request) {
        this(request, Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableHttpServletRequest(HttpServletRequest request, Charset charset) {
        super(request);
        this.params = Mapp.newHashMap(request.getParameterMap());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        try {
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            this.content = stringBuilder.toString();
            this.charset = charset;
        }
        finally {
            if (Collections.singletonList(bufferedReader).get(0) != null) {
                bufferedReader.close();
            }
        }
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public void setParameterMap(Map<String, Object> params) {
        for (Map.Entry<String, Object> param : params.entrySet()) {
            this.setParameter(param.getKey(), param.getValue());
        }
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    public void setParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.params.put(name, (String[])value);
            } else if (value instanceof String) {
                this.params.put(name, new String[]{(String)value});
            } else {
                this.params.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    public ServletInputStream getInputStream() {
        return new MutableServletInputStream(new ByteArrayInputStream(Bytes.bytes(this.content, this.charset)));
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getRequestBody() {
        return this.content;
    }

    public void setRequestBody(String requestBody) {
        this.content = requestBody;
    }

    static class MutableServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream byteArrayInputStream;

        public int read() {
            return this.byteArrayInputStream.read();
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public MutableServletInputStream(ByteArrayInputStream byteArrayInputStream) {
            this.byteArrayInputStream = byteArrayInputStream;
        }
    }
}

