/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.spring;

import com.github.charlemaznable.core.codec.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MutableHttpServletResponse
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private MutableServletOutputStream mutableServletOutputStream = new MutableServletOutputStream(this.byteArrayOutputStream);
    private PrintWriter printWriter;

    public MutableHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() {
        return this.mutableServletOutputStream;
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.byteArrayOutputStream);
        }
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        this.byteArrayOutputStream.flush();
    }

    public byte[] getContent() {
        this.flushBuffer();
        return this.byteArrayOutputStream.toByteArray();
    }

    public void setContent(byte[] content) {
        this.byteArrayOutputStream.reset();
        this.byteArrayOutputStream.write(content);
    }

    public void appendContent(byte[] content) {
        this.byteArrayOutputStream.write(content);
    }

    public String getContentAsString() {
        return Bytes.string(this.getContent());
    }

    public void setContentByString(String content) {
        this.setContent(Bytes.bytes(content));
    }

    public void appendContentByString(String content) {
        this.appendContent(Bytes.bytes(content));
    }

    public String getContentAsString(Charset charset) {
        return Bytes.string(this.getContent(), charset);
    }

    public void setContentByString(String content, Charset charset) {
        this.setContent(Bytes.bytes(content, charset));
    }

    public void appendContentByString(String content, Charset charset) {
        this.appendContent(Bytes.bytes(content, charset));
    }

    static class MutableServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream byteArrayOutputStream;

        public void write(int b) {
            this.byteArrayOutputStream.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public MutableServletOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.byteArrayOutputStream = byteArrayOutputStream;
        }
    }
}

