/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.spring;

import com.github.charlemaznable.core.spring.MutableHttpServletRequest;
import com.github.charlemaznable.core.spring.MutableHttpServletResponse;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MutableHttpServletUtils {
    public static MutableHttpServletRequest mutableRequest(HttpServletRequest request) {
        HttpServletRequest internalRequest = request;
        while (internalRequest instanceof HttpServletRequestWrapper) {
            if (internalRequest instanceof MutableHttpServletRequest) {
                return (MutableHttpServletRequest)internalRequest;
            }
            internalRequest = MutableHttpServletUtils.internalRequest((HttpServletRequestWrapper)internalRequest);
        }
        return null;
    }

    public static MutableHttpServletResponse mutableResponse(HttpServletResponse response) {
        HttpServletResponse internalResponse = response;
        while (internalResponse instanceof HttpServletResponseWrapper) {
            if (internalResponse instanceof MutableHttpServletResponse) {
                return (MutableHttpServletResponse)internalResponse;
            }
            internalResponse = MutableHttpServletUtils.internalResponse((HttpServletResponseWrapper)internalResponse);
        }
        return null;
    }

    public static void setRequestBody(HttpServletRequest request, String body) {
        MutableHttpServletRequest mutableRequest = MutableHttpServletUtils.mutableRequest(request);
        if (null == mutableRequest) {
            return;
        }
        mutableRequest.setRequestBody(body);
    }

    public static void setRequestParameter(HttpServletRequest request, String name, Object value) {
        MutableHttpServletRequest mutableRequest = MutableHttpServletUtils.mutableRequest(request);
        if (null == mutableRequest) {
            return;
        }
        mutableRequest.setParameter(name, value);
    }

    public static void setRequestParameterMap(HttpServletRequest request, Map<String, Object> params) {
        MutableHttpServletRequest mutableRequest = MutableHttpServletUtils.mutableRequest(request);
        if (null == mutableRequest) {
            return;
        }
        mutableRequest.setParameterMap(params);
    }

    public static byte[] getResponseContent(HttpServletResponse response) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return null;
        }
        return mutableResponse.getContent();
    }

    public static void setResponseContent(HttpServletResponse response, byte[] content) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutableResponse.setContent(content);
    }

    public static void appendResponseContent(HttpServletResponse response, byte[] content) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutableResponse.appendContent(content);
    }

    public static String getResponseContentAsString(HttpServletResponse response) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return null;
        }
        return mutableResponse.getContentAsString();
    }

    public static void setResponseContentByString(HttpServletResponse response, String content) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutableResponse.setContentByString(content);
    }

    public static void appendResponseContentByString(HttpServletResponse response, String content) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutableResponse.appendContentByString(content);
    }

    public static String getResponseContentAsString(HttpServletResponse response, Charset charset) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return null;
        }
        return mutableResponse.getContentAsString(charset);
    }

    public static void setResponseContentByString(HttpServletResponse response, String content, Charset charset) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutableResponse.setContentByString(content, charset);
    }

    public static void appendResponseContentByString(HttpServletResponse response, String content, Charset charset) {
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutableResponse.appendContentByString(content, charset);
    }

    public static void mutateResponse(HttpServletResponse response, Consumer<MutableHttpServletResponse> mutator) {
        if (null == mutator) {
            return;
        }
        MutableHttpServletResponse mutableResponse = MutableHttpServletUtils.mutableResponse(response);
        if (null == mutableResponse) {
            return;
        }
        mutator.accept(mutableResponse);
    }

    private static HttpServletRequest internalRequest(HttpServletRequestWrapper requestWrapper) {
        return (HttpServletRequest)requestWrapper.getRequest();
    }

    private static HttpServletResponse internalResponse(HttpServletResponseWrapper responseWrapper) {
        return (HttpServletResponse)responseWrapper.getResponse();
    }
}

