/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.spring;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class SpringClassPathScanner
extends ClassPathBeanDefinitionScanner {
    private final Class factoryBeanClass;
    private final Function<ClassMetadata, Boolean> isCandidateClass;
    private final Class<? extends Annotation>[] annotationClasses;

    @SafeVarargs
    public SpringClassPathScanner(BeanDefinitionRegistry registry, Class factoryBeanClass, Function<ClassMetadata, Boolean> isCandidateClass, Class<? extends Annotation> ... annotationClasses) {
        super(registry, false);
        this.factoryBeanClass = factoryBeanClass;
        this.isCandidateClass = isCandidateClass;
        this.annotationClasses = annotationClasses;
    }

    public void registerFilters() {
        for (Class<? extends Annotation> annotationClass : this.annotationClasses) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationClass));
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No " + this.factoryBeanClass.getSimpleName() + " was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        } else {
            for (BeanDefinitionHolder holder : beanDefinitions) {
                GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating " + this.factoryBeanClass.getSimpleName() + " with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' xyzInterface"));
                }
                definition.getPropertyValues().add("xyzInterface", (Object)definition.getBeanClassName());
                definition.setBeanClass(this.factoryBeanClass);
            }
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return null == this.isCandidateClass ? true : this.isCandidateClass.apply((ClassMetadata)beanDefinition.getMetadata());
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) throws IllegalStateException {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn((Object)("Skipping " + this.factoryBeanClass.getSimpleName() + " with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' interface. Bean already defined with the same name!"));
        return false;
    }
}

