/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.core.spring;

import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Str;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static <T> T getBean(String beanName) {
        return SpringContext.getBean(beanName, null);
    }

    public static <T> T getBean(String beanName, T defaultValue) {
        return (T)SpringContext.getBean(beanName, () -> defaultValue);
    }

    public static <T> T getBean(String beanName, Supplier<T> defaultSupplier) {
        if (applicationContext == null) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
        if (Str.isEmpty(beanName)) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
        try {
            return (T)applicationContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        return SpringContext.getBean(clazz, null);
    }

    public static <T> T getBean(Class<T> clazz, T defaultValue) {
        return (T)SpringContext.getBean(clazz, () -> defaultValue);
    }

    public static <T> T getBean(Class<T> clazz, Supplier<T> defaultSupplier) {
        if (applicationContext == null) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
        if (clazz == null) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
    }

    public static <T> T getBean(String beanName, Class<T> clazz) {
        return SpringContext.getBean(beanName, clazz, null);
    }

    public static <T> T getBean(String beanName, Class<T> clazz, T defaultValue) {
        return (T)SpringContext.getBean(beanName, clazz, () -> defaultValue);
    }

    public static <T> T getBean(String beanName, Class<T> clazz, Supplier<T> defaultSupplier) {
        if (applicationContext == null) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
        if (Str.isEmpty(beanName) && clazz == null) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
        if (Str.isEmpty(beanName)) {
            return SpringContext.getBean(clazz, defaultSupplier);
        }
        if (clazz == null) {
            return SpringContext.getBean(beanName, defaultSupplier);
        }
        try {
            return (T)applicationContext.getBean(beanName, clazz);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return (T)Condition.notNullThen(defaultSupplier, Supplier::get);
        }
    }

    public static String[] getBeanNamesForType(Class<?> clazz) {
        if (applicationContext == null) {
            return new String[0];
        }
        if (clazz == null) {
            return new String[0];
        }
        return applicationContext.getBeanNamesForType(clazz);
    }

    public static String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotation) {
        if (applicationContext == null) {
            return new String[0];
        }
        if (annotation == null) {
            return new String[0];
        }
        return applicationContext.getBeanNamesForAnnotation(annotation);
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        applicationContext = context;
    }
}

