/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.varys.api;

import com.github.charlemaznable.net.HttpReq;
import com.github.charlemaznable.varys.Config;
import java.util.Map;

public class Proxy {
    private static final String proxyWechatAppPath = "/proxy-wechat-app/";
    private static final String proxyWechatCorpPath = "/proxy-wechat-corp/";
    private final Config config;

    public ProxyReq wechatApp(String codeName, String proxyPath) {
        return new ProxyReq(this.config.address() + proxyWechatAppPath + codeName + Proxy.fixProxyPath(proxyPath));
    }

    public ProxyReq wechatApp(String codeName, String proxyPathTemplate, Object ... proxyPathArgs) {
        return new ProxyReq(this.config.address() + proxyWechatAppPath + codeName + Proxy.fixProxyPath(String.format(proxyPathTemplate, proxyPathArgs)));
    }

    public ProxyReq wechatCorp(String codeName, String proxyPath) {
        return new ProxyReq(this.config.address() + proxyWechatCorpPath + codeName + Proxy.fixProxyPath(proxyPath));
    }

    public ProxyReq wechatCorp(String codeName, String proxyPathTemplate, Object ... proxyPathArgs) {
        return new ProxyReq(this.config.address() + proxyWechatCorpPath + codeName + Proxy.fixProxyPath(String.format(proxyPathTemplate, proxyPathArgs)));
    }

    private static String fixProxyPath(String proxyPath) {
        return proxyPath.startsWith("/") ? proxyPath : "/" + proxyPath;
    }

    public Proxy(Config config) {
        this.config = config;
    }

    public class ProxyReq {
        private HttpReq httpReq;

        private ProxyReq(String baseUrl) {
            this.httpReq = new HttpReq(baseUrl);
        }

        public ProxyReq prop(String name, String value) {
            this.httpReq.prop(name, value);
            return this;
        }

        public ProxyReq param(String name, String value) {
            this.httpReq.param(name, value);
            return this;
        }

        public ProxyReq params(Map<String, String> params) {
            this.httpReq.params(params);
            return this;
        }

        public String get() {
            return this.httpReq.get();
        }

        public String post() {
            return this.httpReq.post();
        }
    }
}

