/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.varys.api;

import com.github.charlemaznable.codec.Json;
import com.github.charlemaznable.lang.LoadingCachee;
import com.github.charlemaznable.net.HttpReq;
import com.github.charlemaznable.varys.Config;
import com.github.charlemaznable.varys.resp.AppAuthorizerTokenResp;
import com.github.charlemaznable.varys.resp.AppTokenResp;
import com.github.charlemaznable.varys.resp.CorpAuthorizerTokenResp;
import com.github.charlemaznable.varys.resp.CorpTokenResp;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;

public class Query {
    private static final String appTokenCachePath = "/query-wechat-app-token/";
    private static final String appAuthorizerTokenCachePath = "/query-wechat-app-authorizer-token/";
    private static final String corpTokenCachePath = "/query-wechat-corp-token/";
    private static final String corpAuthorizerTokenCachePath = "/query-wechat-corp-authorizer-token/";
    private LoadingCache<String, AppTokenResp> appTokenCache;
    private LoadingCache<Pair<String, String>, AppAuthorizerTokenResp> appAuthorizerTokenCache;
    private LoadingCache<String, CorpTokenResp> corpTokenCache;
    private LoadingCache<Pair<String, String>, CorpAuthorizerTokenResp> corpAuthorizerTokenCache;

    public Query(Config config) {
        this.appTokenCache = LoadingCachee.writeCache((CacheLoader)new QueryCacheLoader<String, AppTokenResp>(config){

            public AppTokenResp load(@Nonnull String codeName) {
                return (AppTokenResp)Json.unJson((String)this.httpGet(Query.appTokenCachePath + codeName), AppTokenResp.class);
            }
        }, (long)config.appTokenCacheDuration(), (TimeUnit)config.appTokenCacheTimeUnit());
        this.appAuthorizerTokenCache = LoadingCachee.writeCache((CacheLoader)new QueryCacheLoader<Pair<String, String>, AppAuthorizerTokenResp>(config){

            public AppAuthorizerTokenResp load(@Nonnull Pair<String, String> pair) {
                String codeName = (String)pair.getLeft();
                String authorizerAppId = (String)pair.getRight();
                return (AppAuthorizerTokenResp)Json.unJson((String)this.httpGet(Query.appAuthorizerTokenCachePath + codeName + "/" + authorizerAppId), AppAuthorizerTokenResp.class);
            }
        }, (long)config.appAuthorizerTokenCacheDuration(), (TimeUnit)config.appAuthorizerTokenCacheTimeUnit());
        this.corpTokenCache = LoadingCachee.writeCache((CacheLoader)new QueryCacheLoader<String, CorpTokenResp>(config){

            public CorpTokenResp load(@Nonnull String codeName) {
                return (CorpTokenResp)Json.unJson((String)this.httpGet(Query.corpTokenCachePath + codeName), CorpTokenResp.class);
            }
        }, (long)config.corpTokenCacheDuration(), (TimeUnit)config.corpTokenCacheTimeUnit());
        this.corpAuthorizerTokenCache = LoadingCachee.writeCache((CacheLoader)new QueryCacheLoader<Pair<String, String>, CorpAuthorizerTokenResp>(config){

            public CorpAuthorizerTokenResp load(@Nonnull Pair<String, String> pair) {
                String codeName = (String)pair.getLeft();
                String corpId = (String)pair.getRight();
                return (CorpAuthorizerTokenResp)Json.unJson((String)this.httpGet(Query.corpAuthorizerTokenCachePath + codeName + "/" + corpId), CorpAuthorizerTokenResp.class);
            }
        }, (long)config.corpAuthorizerTokenCacheDuration(), (TimeUnit)config.corpAuthorizerTokenCacheTimeUnit());
    }

    public AppTokenResp appToken(String codeName) {
        Preconditions.checkNotNull(this.appTokenCache);
        Preconditions.checkNotNull((Object)codeName);
        return (AppTokenResp)LoadingCachee.get(this.appTokenCache, (Object)codeName);
    }

    public AppAuthorizerTokenResp appAuthorizerToken(String codeName, String authorizerAppId) {
        Preconditions.checkNotNull(this.appAuthorizerTokenCache);
        Preconditions.checkNotNull((Object)codeName);
        Preconditions.checkNotNull((Object)authorizerAppId);
        return (AppAuthorizerTokenResp)LoadingCachee.get(this.appAuthorizerTokenCache, (Object)Pair.of((Object)codeName, (Object)authorizerAppId));
    }

    public CorpTokenResp corpToken(String codeName) {
        Preconditions.checkNotNull(this.corpTokenCache);
        Preconditions.checkNotNull((Object)codeName);
        return (CorpTokenResp)LoadingCachee.get(this.corpTokenCache, (Object)codeName);
    }

    public CorpAuthorizerTokenResp corpAuthorizerToken(String codeName, String corpId) {
        Preconditions.checkNotNull(this.corpAuthorizerTokenCache);
        Preconditions.checkNotNull((Object)codeName);
        Preconditions.checkNotNull((Object)corpId);
        return (CorpAuthorizerTokenResp)LoadingCachee.get(this.corpAuthorizerTokenCache, (Object)Pair.of((Object)codeName, (Object)corpId));
    }

    private static abstract class QueryCacheLoader<K, V>
    extends CacheLoader<K, V> {
        protected final Config config;

        protected String httpGet(String subpath) {
            return (String)Preconditions.checkNotNull((Object)new HttpReq(this.config.address() + subpath).get());
        }

        public QueryCacheLoader(Config config) {
            this.config = config;
        }
    }
}

