/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlemaznable.varys.config;

import com.github.charlemaznable.configservice.Config;
import com.github.charlemaznable.configservice.ConfigFactory;
import com.github.charlemaznable.core.lang.Condition;
import com.github.charlemaznable.core.lang.Listt;
import com.github.charlemaznable.httpclient.configurer.configservice.MappingConfig;
import com.github.charlemaznable.httpclient.ohclient.configurer.configservice.ClientTimeoutConfig;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Config(keyset="Varys", key="${varys-config:-default}")
public interface VarysConfig
extends MappingConfig,
ClientTimeoutConfig {
    public String address();

    default public String urlsString() {
        return (String)Condition.checkNotNull((Object)this.address());
    }

    public static class ProxyShansongAppMerchantConfig
    extends ProxyConfig {
        public ProxyShansongAppMerchantConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-shansong-app-merchant";
        }
    }

    public static class ProxyShansongAppFileConfig
    extends ProxyConfig {
        public ProxyShansongAppFileConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-shansong-app-file";
        }
    }

    public static class ProxyShansongAppDeveloperConfig
    extends ProxyConfig {
        public ProxyShansongAppDeveloperConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-shansong-app-developer";
        }
    }

    public static class ProxyFengniaoAppConfig
    extends ProxyConfig {
        public ProxyFengniaoAppConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-fengniao-app";
        }
    }

    public static class ProxyWechatTpAuthConfig
    extends ProxyConfig {
        public ProxyWechatTpAuthConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-wechat-tp-auth";
        }
    }

    public static class ProxyWechatTpConfig
    extends ProxyConfig {
        public ProxyWechatTpConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-wechat-tp";
        }
    }

    public static class ProxyWechatCorpConfig
    extends ProxyConfig {
        public ProxyWechatCorpConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-wechat-corp";
        }
    }

    public static class ProxyWechatAppConfig
    extends ProxyConfig {
        public ProxyWechatAppConfig(@Nullable VarysConfig varysConfig) {
            super(varysConfig);
        }

        @Override
        public String subpath() {
            return "proxy-wechat-app";
        }
    }

    public static abstract class ProxyConfig
    implements MappingConfig,
    ClientTimeoutConfig {
        private final VarysConfig varysConfig;

        public ProxyConfig(@Nullable VarysConfig varysConfig) {
            this.varysConfig = (VarysConfig)Condition.nullThen((Object)varysConfig, () -> (VarysConfig)ConfigFactory.getConfig(VarysConfig.class));
        }

        public abstract String subpath();

        public List<String> urls() {
            return Listt.newArrayList((Iterable)super.urls()).stream().map(s -> StringUtils.appendIfMissing((String)s, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + this.subpath()).toList();
        }

        @Generated
        public String address() {
            return this.varysConfig.address();
        }

        @Generated
        public String urlsString() {
            return this.varysConfig.urlsString();
        }

        @Generated
        public String callTimeoutString() {
            return this.varysConfig.callTimeoutString();
        }

        @Generated
        public String connectTimeoutString() {
            return this.varysConfig.connectTimeoutString();
        }

        @Generated
        public String readTimeoutString() {
            return this.varysConfig.readTimeoutString();
        }

        @Generated
        public String writeTimeoutString() {
            return this.varysConfig.writeTimeoutString();
        }

        @Generated
        public long callTimeout() {
            return this.varysConfig.callTimeout();
        }

        @Generated
        public long connectTimeout() {
            return this.varysConfig.connectTimeout();
        }

        @Generated
        public long readTimeout() {
            return this.varysConfig.readTimeout();
        }

        @Generated
        public long writeTimeout() {
            return this.varysConfig.writeTimeout();
        }
    }
}

