/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.util;

import com.checkmarx.util.cmd.RoleCommand;
import com.checkmarx.util.cmd.TeamCommand;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
public class CheckmarxUtilRunner
implements CommandLineRunner,
ExitCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(CheckmarxUtilRunner.class);
    private final CommandLine.IFactory factory;
    private final TeamCommand teamCommand;
    private final RoleCommand roleCommand;
    private int exitCode = 0;

    public CheckmarxUtilRunner(CommandLine.IFactory factory, TeamCommand teamCommand, RoleCommand roleCommand) {
        this.factory = factory;
        this.teamCommand = teamCommand;
        this.roleCommand = roleCommand;
    }

    public void run(String[] args) {
        List<String> argsList;
        if (args == null && args.length == 0) {
            this.exitCode = -1;
            System.exit(-1);
        }
        if ((argsList = Arrays.asList(args)).contains("-command=team") || argsList.contains("--command=team")) {
            this.exitCode = new CommandLine((Object)this.teamCommand, this.factory).execute(args);
        } else if (argsList.contains("-command=role") || argsList.contains("--command=role")) {
            this.exitCode = new CommandLine((Object)this.roleCommand, this.factory).execute(args);
        } else {
            log.info("No valid option given");
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

