/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.util.cmd;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.service.CxClient;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@CommandLine.Command
public class RoleCommand
implements Callable<Integer> {
    private static final Logger log = LoggerFactory.getLogger(RoleCommand.class);
    private final CxClient cxClient;
    private final CxProperties cxProperties;
    @CommandLine.Option(names={"-command", "--command"}, description={"Command name"})
    private String command;
    @CommandLine.Option(names={"-action", "--action"}, description={"Action to execute - add-ldap, remove-ldap,"})
    private String action;
    @CommandLine.Option(names={"-s", "--ldap-server"}, description={"LDAP Server Name"})
    private String ldapServer;
    @CommandLine.Option(names={"-r", "--role"}, description={"Role Name"})
    private String role;
    @CommandLine.Option(names={"-m", "--ldap-dn"}, description={"Add LDAP DN Mapping"})
    private String ldapDn;
    @CommandLine.Parameters
    private String[] remainder;
    @CommandLine.Unmatched
    private String[] unknown;

    public RoleCommand(CxClient cxClient, CxProperties cxProperties) {
        this.cxClient = cxClient;
        this.cxProperties = cxProperties;
    }

    @Override
    public Integer call() throws Exception {
        log.info("Calling Role Command");
        if ("ADD-LDAP".equals(this.action.toUpperCase())) {
            this.addLdapMapping();
        } else if ("REMOVE-LDAP".equals(this.action.toUpperCase())) {
            this.removeLdapMapping();
        }
        return 0;
    }

    private void addLdapMapping() throws CheckmarxException {
        Integer serverId;
        Integer roleId = this.cxClient.getRoleId(this.role);
        if (roleId.equals(-1)) {
            log.error("Could not find role {}", (Object)this.role);
            throw new CheckmarxException("Could not find role ".concat(this.role));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ldapServer)) {
            serverId = this.cxClient.getLdapServerId(this.ldapServer);
            if (serverId <= 0) {
                log.error("Ldap Server {} not found ", (Object)this.ldapServer);
                throw new CheckmarxException("Ldap Server not found");
            }
        } else {
            log.error("No Ldap Server provided");
            throw new CheckmarxException("Ldap Server not provided");
        }
        this.cxClient.mapRoleLdap(serverId, roleId, this.ldapDn);
        log.info("Ldap mapping {} has been added to role {}", (Object)this.ldapDn, (Object)this.role);
    }

    private void removeLdapMapping() throws CheckmarxException {
        Integer serverId;
        Integer roleId = this.cxClient.getRoleId(this.role);
        if (roleId.equals(-1)) {
            log.error("Could not find role {}", (Object)this.role);
            throw new CheckmarxException("Could not find role ".concat(this.role));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ldapServer)) {
            serverId = this.cxClient.getLdapServerId(this.ldapServer);
            if (serverId <= 0) {
                log.error("Ldap Server {} not found ", (Object)this.ldapServer);
                throw new CheckmarxException("Ldap Server not found");
            }
        } else {
            log.error("No Ldap Server provided");
            throw new CheckmarxException("Ldap Server not provided");
        }
        this.cxClient.removeRoleLdap(serverId, roleId, this.ldapDn);
        log.info("Ldap mapping {} has been removed from role {}", (Object)this.ldapDn, (Object)this.role);
    }
}

