/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.util.cmd;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.service.CxClient;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@CommandLine.Command
public class TeamCommand
implements Callable<Integer> {
    private static final Logger log = LoggerFactory.getLogger(TeamCommand.class);
    private final CxClient cxClient;
    private final CxProperties cxProperties;
    @CommandLine.Option(names={"-command", "--command"}, description={"Command name"})
    private String command;
    @CommandLine.Option(names={"-action", "--action"}, description={"Action to execute - create, delete, add-ldap, remove-ldap,"})
    private String action;
    @CommandLine.Option(names={"-t", "--team"}, description={"Checkmarx Team"})
    private String team;
    @CommandLine.Option(names={"-create", "--create"}, description={"Create team if it does not exist (parent team must exist)"})
    private boolean create;
    @CommandLine.Option(names={"-s", "--ldap-server"}, description={"LDAP Server Name"})
    private String ldapServer;
    @CommandLine.Option(names={"-m", "--add-ldap-map"}, description={"Add LDAP DN Mapping"})
    private String addLdapDn;
    @CommandLine.Option(names={"-r", "--remove-ldap-map"}, description={"Remove LDAP DN Mapping"})
    private String removeLdapDn;
    @CommandLine.Parameters
    private String[] remainder;
    @CommandLine.Unmatched
    private String[] unknown;

    public TeamCommand(CxClient cxClient, CxProperties cxProperties) {
        this.cxClient = cxClient;
        this.cxProperties = cxProperties;
    }

    @Override
    public Integer call() throws Exception {
        log.info("Calling Team Command");
        if (!this.team.startsWith(this.cxProperties.getTeamPathSeparator())) {
            this.team = this.cxProperties.getTeamPathSeparator().concat(this.team);
        }
        switch (this.action.toUpperCase()) {
            case "CREATE": {
                this.createTeam();
                break;
            }
            case "DELETE": {
                this.deleteTeam();
                break;
            }
            case "ADD-LDAP": {
                this.addLdapMapping();
                break;
            }
            case "REMOVE-LDAP": {
                this.removeLdapMapping();
            }
        }
        return 0;
    }

    private void addLdapMapping() throws CheckmarxException {
        Integer serverId;
        if (this.create) {
            log.info("Creating team if it does not exits.");
            this.createTeam();
        }
        String teamId = this.cxClient.getTeamId(this.team);
        String teamName = this.getTeamName();
        if (teamId.equals("-1")) {
            log.error("Could not find team {}", (Object)this.team);
            throw new CheckmarxException("Could not find team ".concat(this.team));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ldapServer)) {
            serverId = this.cxClient.getLdapServerId(this.ldapServer);
            if (serverId <= 0) {
                log.error("Ldap Server {} not found ", (Object)this.ldapServer);
                throw new CheckmarxException("Ldap Server not found");
            }
        } else {
            log.error("No Ldap Server provided");
            throw new CheckmarxException("Ldap Server not provided");
        }
        this.cxClient.mapTeamLdapWS(serverId, teamId, teamName, this.addLdapDn);
        log.info("Ldap mapping {} has been added to team {}", (Object)this.addLdapDn, (Object)this.team);
    }

    private void removeLdapMapping() throws CheckmarxException {
        Integer serverId;
        String teamId = this.cxClient.getTeamId(this.team);
        String teamName = this.getTeamName();
        if (teamId.equals("-1")) {
            log.error("Could not find team {}", (Object)this.team);
            throw new CheckmarxException("Could not find team ".concat(this.team));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ldapServer)) {
            serverId = this.cxClient.getLdapServerId(this.ldapServer);
            if (serverId <= 0) {
                log.error("Ldap Server {} not found ", (Object)this.ldapServer);
                throw new CheckmarxException("Ldap Server not found");
            }
        } else {
            log.error("No Ldap Server provided");
            throw new CheckmarxException("Ldap Server not provided");
        }
        this.cxClient.removeTeamLdapWS(serverId, teamId, teamName, this.addLdapDn);
        log.info("Ldap mapping {} has been removed from team {}", (Object)this.addLdapDn, (Object)this.team);
    }

    private void createTeam() throws CheckmarxException {
        if (!this.cxClient.getTeamId(this.team).equals("-1")) {
            log.warn("Team already exists...");
            return;
        }
        int idx = this.team.lastIndexOf(this.cxProperties.getTeamPathSeparator());
        String parentPath = this.team.substring(0, idx);
        String teamName = this.getTeamName();
        log.info("Parent path: {}", (Object)parentPath);
        String parentId = this.cxClient.getTeamId(parentPath);
        log.info(parentId);
        this.cxClient.createTeam(parentId, teamName);
    }

    private void deleteTeam() throws CheckmarxException {
        String teamId = this.cxClient.getTeamId(this.team);
        if (teamId.equals("-1")) {
            log.warn("Could not find team {}", (Object)this.team);
        } else {
            log.info("Deleting team {} with Id {}", (Object)this.team, (Object)teamId);
            this.cxClient.deleteTeam(teamId);
        }
    }

    private String getTeamName() {
        int idx = this.team.lastIndexOf(this.cxProperties.getTeamPathSeparator());
        return this.team.substring(idx + 1);
    }
}

