/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ScanResults;
import com.checkmarx.sdk.dto.cx.CxProject;
import com.checkmarx.sdk.dto.cx.CxRole;
import com.checkmarx.sdk.dto.cx.CxRoleLdap;
import com.checkmarx.sdk.dto.cx.CxScanParams;
import com.checkmarx.sdk.dto.cx.CxScanSettings;
import com.checkmarx.sdk.dto.cx.CxScanSummary;
import com.checkmarx.sdk.dto.cx.CxTeam;
import com.checkmarx.sdk.dto.cx.CxTeamLdap;
import com.checkmarx.sdk.dto.cx.xml.CxXMLResultsType;
import com.checkmarx.sdk.exception.CheckmarxException;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public interface CxClient {
    public Integer getLastScanId(Integer var1);

    public JSONObject getScanData(String var1);

    public LocalDateTime getLastScanDate(Integer var1);

    public Integer getScanStatus(Integer var1);

    public Integer createScanReport(Integer var1);

    public Integer getReportStatus(Integer var1) throws CheckmarxException;

    public ScanResults getReportContentByScanId(Integer var1, List<Filter> var2) throws CheckmarxException;

    public ScanResults getReportContent(Integer var1, List<Filter> var2) throws CheckmarxException;

    public CxXMLResultsType getXmlReportContent(Integer var1) throws CheckmarxException;

    public Map<String, String> getCustomFields(Integer var1);

    public ScanResults getReportContent(File var1, List<Filter> var2) throws CheckmarxException;

    public ScanResults getOsaReportContent(File var1, File var2, List<Filter> var3) throws CheckmarxException;

    public String getIssueDescription(Long var1, Long var2);

    public Integer createProject(String var1, String var2);

    public void deleteProject(Integer var1);

    public Integer branchProject(Integer var1, String var2);

    public List<CxProject> getProjects() throws CheckmarxException;

    public List<CxProject> getProjects(String var1) throws CheckmarxException;

    public Integer getProjectId(String var1, String var2);

    public CxProject getProject(Integer var1);

    public boolean scanExists(Integer var1);

    public Integer createScanSetting(Integer var1, Integer var2, Integer var3);

    public String getScanSetting(Integer var1);

    public CxScanSettings getScanSettingsDto(int var1);

    public String getPresetName(Integer var1);

    public Integer getProjectPresetId(Integer var1);

    public void setProjectRepositoryDetails(Integer var1, String var2, String var3) throws CheckmarxException;

    public void updateProjectDetails(CxProject var1) throws CheckmarxException;

    public void uploadProjectSource(Integer var1, File var2) throws CheckmarxException;

    public void setProjectExcludeDetails(Integer var1, List<String> var2, List<String> var3);

    public Integer getLdapTeamMapId(Integer var1, String var2, String var3) throws CheckmarxException;

    public String getTeamId(String var1) throws CheckmarxException;

    public List<CxTeam> getTeams() throws CheckmarxException;

    public void mapTeamLdap(Integer var1, String var2, String var3, String var4) throws CheckmarxException;

    public List<CxTeamLdap> getTeamLdap(Integer var1) throws CheckmarxException;

    public void removeTeamLdap(Integer var1, String var2, String var3, String var4) throws CheckmarxException;

    public List<CxRole> getRoles() throws CheckmarxException;

    public Integer getRoleId(String var1) throws CheckmarxException;

    public List<CxRoleLdap> getRoleLdap(Integer var1) throws CheckmarxException;

    public Integer getLdapRoleMapId(Integer var1, Integer var2, String var3) throws CheckmarxException;

    public void mapRoleLdap(Integer var1, Integer var2, String var3) throws CheckmarxException;

    public void removeRoleLdap(Integer var1) throws CheckmarxException;

    public void removeRoleLdap(Integer var1, Integer var2, String var3) throws CheckmarxException;

    public void mapTeamLdapWS(Integer var1, String var2, String var3, String var4) throws CheckmarxException;

    public void removeTeamLdapWS(Integer var1, String var2, String var3, String var4) throws CheckmarxException;

    public String createTeamWS(String var1, String var2) throws CheckmarxException;

    public String createTeam(String var1, String var2) throws CheckmarxException;

    public void moveTeam(String var1, String var2) throws CheckmarxException;

    public void renameTeam(String var1, String var2) throws CheckmarxException;

    public void deleteTeam(String var1) throws CheckmarxException;

    public String getTeamId(String var1, String var2) throws CheckmarxException;

    public void deleteTeamWS(String var1) throws CheckmarxException;

    public Integer getScanConfiguration(String var1) throws CheckmarxException;

    public String getScanConfigurationName(int var1);

    public Integer getPresetId(String var1) throws CheckmarxException;

    public CxScanSummary getScanSummaryByScanId(Integer var1) throws CheckmarxException;

    public CxScanSummary getScanSummary(Integer var1) throws CheckmarxException;

    public CxScanSummary getScanSummary(String var1, String var2) throws CheckmarxException;

    public Integer createScan(CxScanParams var1, String var2) throws CheckmarxException;

    public void waitForScanCompletion(Integer var1) throws CheckmarxException;

    public void deleteScan(Integer var1) throws CheckmarxException;

    public CxXMLResultsType createScanAndReport(CxScanParams var1, String var2) throws CheckmarxException;

    public ScanResults createScanAndReport(CxScanParams var1, String var2, List<Filter> var3) throws CheckmarxException;

    public CxXMLResultsType getLatestScanReport(String var1, String var2) throws CheckmarxException;

    public ScanResults getLatestScanResults(String var1, String var2, List<Filter> var3) throws CheckmarxException;

    public Integer getLdapServerId(String var1) throws CheckmarxException;
}

