/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.dto;

import java.beans.ConstructorProperties;
import java.util.Objects;

public class Filter {
    private Type type;
    private String value;

    @ConstructorProperties(value={"type", "value"})
    public Filter(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public static FilterBuilder builder() {
        return new FilterBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter filter = (Filter)o;
        return this.getType().equals((Object)filter.getType()) && this.getValue().equalsIgnoreCase(filter.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Filter(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
    }

    public static class FilterBuilder {
        private Type type;
        private String value;

        FilterBuilder() {
        }

        public FilterBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public FilterBuilder value(String value) {
            this.value = value;
            return this;
        }

        public Filter build() {
            return new Filter(this.type, this.value);
        }

        public String toString() {
            return "Filter.FilterBuilder(type=" + (Object)((Object)this.type) + ", value=" + this.value + ")";
        }
    }

    public static enum Severity {
        CRITICAL("Critical"),
        HIGH("High"),
        MEDIUM("Medium"),
        LOW("Low"),
        INFO("Informational");

        private final String severityName;

        private Severity(String severityName) {
            this.severityName = severityName;
        }

        public String getSeverityName() {
            return this.severityName;
        }
    }

    public static enum Type {
        SEVERITY("SEVERITY"),
        CWE("CWE"),
        OWASP("OWASP"),
        TYPE("TYPE"),
        STATUS("STATUS"),
        STATE("STATE");

        private final String typeName;

        private Type(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

