/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.dto.cx;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;

public class CxAuthRequest {
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="grant_type")
    private String grantType = "password";
    @JsonProperty(value="scope")
    private String scope = "sast_rest_api";
    @JsonProperty(value="client_id")
    private String clientId = "resource_owner_client";
    @JsonProperty(value="client_secret")
    private String clientSecret;

    @ConstructorProperties(value={"username", "password", "grantType", "scope", "clientId", "clientSecret"})
    CxAuthRequest(String username, String password, String grantType, String scope, String clientId, String clientSecret) {
        this.username = username;
        this.password = password;
        this.grantType = grantType;
        this.scope = scope;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static CxAuthRequestBuilder builder() {
        return new CxAuthRequestBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String toString() {
        return "CxAuthRequest(username=" + this.getUsername() + ", password=" + this.getPassword() + ", grantType=" + this.getGrantType() + ", scope=" + this.getScope() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ")";
    }

    public static class CxAuthRequestBuilder {
        private String username;
        private String password;
        private String grantType;
        private String scope;
        private String clientId;
        private String clientSecret;

        CxAuthRequestBuilder() {
        }

        public CxAuthRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        public CxAuthRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        public CxAuthRequestBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public CxAuthRequestBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public CxAuthRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public CxAuthRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public CxAuthRequest build() {
            return new CxAuthRequest(this.username, this.password, this.grantType, this.scope, this.clientId, this.clientSecret);
        }

        public String toString() {
            return "CxAuthRequest.CxAuthRequestBuilder(username=" + this.username + ", password=" + this.password + ", grantType=" + this.grantType + ", scope=" + this.scope + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ")";
        }
    }
}

