/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import checkmarx.wsdl.portal.AddNewUser;
import checkmarx.wsdl.portal.AddNewUserResponse;
import checkmarx.wsdl.portal.ArrayOfCxWSLdapGroupMapping;
import checkmarx.wsdl.portal.ArrayOfGroup;
import checkmarx.wsdl.portal.CreateNewTeam;
import checkmarx.wsdl.portal.CreateNewTeamResponse;
import checkmarx.wsdl.portal.Credentials;
import checkmarx.wsdl.portal.CxUserTypes;
import checkmarx.wsdl.portal.CxWSLdapGroup;
import checkmarx.wsdl.portal.CxWSLdapGroupMapping;
import checkmarx.wsdl.portal.CxWSLdapServerConfiguration;
import checkmarx.wsdl.portal.CxWSRoleWithUserPrivileges;
import checkmarx.wsdl.portal.DeleteTeam;
import checkmarx.wsdl.portal.DeleteTeamResponse;
import checkmarx.wsdl.portal.DeleteUser;
import checkmarx.wsdl.portal.DeleteUserResponse;
import checkmarx.wsdl.portal.GetAllCompanies;
import checkmarx.wsdl.portal.GetAllCompaniesResponse;
import checkmarx.wsdl.portal.GetAllUsers;
import checkmarx.wsdl.portal.GetAllUsersResponse;
import checkmarx.wsdl.portal.GetLdapServersConfigurations;
import checkmarx.wsdl.portal.GetLdapServersConfigurationsResponse;
import checkmarx.wsdl.portal.GetResultDescription;
import checkmarx.wsdl.portal.GetResultDescriptionResponse;
import checkmarx.wsdl.portal.GetTeamLdapGroupsMapping;
import checkmarx.wsdl.portal.GetTeamLdapGroupsMappingResponse;
import checkmarx.wsdl.portal.GetUserById;
import checkmarx.wsdl.portal.GetUserByIdResponse;
import checkmarx.wsdl.portal.Group;
import checkmarx.wsdl.portal.GroupType;
import checkmarx.wsdl.portal.LoginV2;
import checkmarx.wsdl.portal.LoginV2Response;
import checkmarx.wsdl.portal.MoveTeam;
import checkmarx.wsdl.portal.MoveTeamResponse;
import checkmarx.wsdl.portal.TeamData;
import checkmarx.wsdl.portal.UpdateTeam;
import checkmarx.wsdl.portal.UpdateTeamResponse;
import checkmarx.wsdl.portal.UpdateUserData;
import checkmarx.wsdl.portal.UpdateUserDataResponse;
import checkmarx.wsdl.portal.UserData;
import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.CxUser;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.exception.CheckmarxLegacyException;
import com.checkmarx.sdk.service.CxService;
import com.checkmarx.sdk.utils.ScanUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpUrlConnection;

@Component
public class CxLegacyService {
    private static final Logger log = LoggerFactory.getLogger(CxLegacyService.class);
    private final CxProperties properties;
    private final WebServiceTemplate ws;
    private static final String CX_WS_PREFIX = "http://Checkmarx.com/";
    private static final String CX_WS_LOGIN_URI = "http://Checkmarx.com/LoginV2";
    private static final String CX_WS_DESCRIPTION_URI = "http://Checkmarx.com/GetResultDescription";
    private static final String CX_WS_LDAP_CONFIGURATIONS_URI = "http://Checkmarx.com/GetLdapServersConfigurations";
    private static final String CX_WS_TEAM_LDAP_MAPPINGS_URI = "http://Checkmarx.com/GetTeamLdapGroupsMapping";
    private static final String CX_WS_ADD_USER = "http://Checkmarx.com/AddNewUser";
    private static final String CX_WS_UPDATE_USER = "http://Checkmarx.com/UpdateUserData";
    private static final String CX_WS_ALL_USERS = "http://Checkmarx.com/GetAllUsers";
    private static final String CX_WS_GET_USER = "http://Checkmarx.com/GetUserById";
    private static final String CX_WS_UPDATE_TEAM_URI = "http://Checkmarx.com/UpdateTeam";
    private static final String CX_WS_CREATE_TEAM_URI = "http://Checkmarx.com/CreateNewTeam";
    private static final String CX_WS_DELETE_TEAM_URI = "http://Checkmarx.com/DeleteTeam";
    private static final String CX_WS_MOVE_TEAM_URI = "http://Checkmarx.com/MoveTeam";
    private static final String CX_WS_GET_COMPANIES_TEAM_URI = "http://Checkmarx.com/GetAllCompanies";
    private static final Map<Integer, CxUser.Role8x> ROLEMAP = ImmutableMap.of((Object)0, (Object)((Object)CxUser.Role8x.SCANNER), (Object)1, (Object)((Object)CxUser.Role8x.REVIEWER), (Object)2, (Object)((Object)CxUser.Role8x.COMPANYMANAGER), (Object)4, (Object)((Object)CxUser.Role8x.SPMANAGER), (Object)5, (Object)((Object)CxUser.Role8x.SERVERMANAGER));

    public CxLegacyService(CxProperties properties, WebServiceTemplate ws) {
        this.properties = properties;
        this.ws = ws;
    }

    public String login(String username, String password) throws CheckmarxLegacyException {
        LoginV2 request = new LoginV2();
        request.setApplicationCredentials(new Credentials(username, password));
        if (this.properties.getVersion() >= 9.0) {
            return "-1";
        }
        LoginV2Response response = (LoginV2Response)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_LOGIN_URI));
        try {
            if (!response.getLoginV2Result().isIsSuccesfull()) {
                throw new CheckmarxLegacyException("Authentication Error");
            }
            return response.getLoginV2Result().getSessionId();
        }
        catch (NullPointerException e) {
            log.error("Authentication Error while logging into CX using SOAP WS");
            throw new CheckmarxLegacyException("Authentication Error");
        }
    }

    public String getCompany(String session, String company) throws CheckmarxLegacyException {
        GetAllCompanies request = new GetAllCompanies();
        request.setSessionID(session);
        GetAllCompaniesResponse response = (GetAllCompaniesResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_GET_COMPANIES_TEAM_URI));
        if (!response.getGetAllCompaniesResult().isIsSuccesfull()) {
            throw new CheckmarxLegacyException("Error getting Companies: " + response.getGetAllCompaniesResult().getErrorMessage());
        }
        List<TeamData> teams = response.getGetAllCompaniesResult().getTeamDataList().getTeamData();
        for (TeamData t : teams) {
            String team = t.getCompany().getGroupName();
            if (!team.equalsIgnoreCase(company)) continue;
            return t.getCompany().getGuid();
        }
        throw new CheckmarxLegacyException("Company not found");
    }

    public List<CxUser> getUsers(String session) throws CheckmarxLegacyException {
        GetAllUsers request = new GetAllUsers();
        request.setSessionID(session);
        GetAllUsersResponse response = (GetAllUsersResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_ALL_USERS));
        if (!response.getGetAllUsersResult().isIsSuccesfull()) {
            throw new CheckmarxLegacyException("Error getting Users: " + response.getGetAllUsersResult().getErrorMessage());
        }
        List<UserData> userData = response.getGetAllUsersResult().getUserDataList().getUserData();
        ArrayList<CxUser> users = new ArrayList<CxUser>();
        for (UserData u : userData) {
            users.add(this.mapUser(u));
        }
        return users;
    }

    public CxUser getUser(String session, Integer id) throws CheckmarxLegacyException {
        GetUserById request = new GetUserById();
        request.setSessionID(session);
        request.setUserId(id.intValue());
        GetUserByIdResponse response = (GetUserByIdResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_GET_USER));
        if (!response.getGetUserByIdResult().isIsSuccesfull()) {
            throw new CheckmarxLegacyException("Error user by Id: " + response.getGetUserByIdResult().getErrorMessage());
        }
        UserData userData = response.getGetUserByIdResult().getUserData();
        return this.mapUser(userData);
    }

    private CxUser mapUser(UserData u) {
        CxUser user = new CxUser();
        user.setId(u.getID());
        user.setActive(u.isIsActive());
        user.setLastLoginDate(u.getLastLoginDate().toString());
        user.setUserName(u.getUserName());
        user.setFirstName(u.getFirstName());
        user.setLastName(u.getLastName());
        user.setEmail(u.getEmail());
        user.setPhoneNumber(u.getPhone());
        user.setCellPhoneNumber(u.getCellPhone());
        user.setJobTitle(u.getJobTitle());
        user.setCountry(u.getCountry());
        user.setAllowedIpList(u.getAllowedIPs().getString());
        user.setCompanyId8x(u.getCompanyID());
        user.setCompany8x(u.getCompanyName());
        user.setUpn(u.getUPN());
        HashMap<String, String> teams = new HashMap<String, String>();
        for (Group g : u.getGroupList().getGroup()) {
            teams.put(g.getID(), g.getGroupName());
        }
        user.setTeams8x(teams);
        CxUser.Role8x role = ROLEMAP.get(Integer.parseInt(u.getRoleData().getID()));
        if (role != null) {
            user.setRole8x(role);
        } else {
            log.warn("Uknown role id {}", (Object)u.getRoleData().getID());
        }
        user.setAuditor(u.isAuditUser());
        return user;
    }

    public void addUser(String session, CxUser user) throws CheckmarxLegacyException {
        if (ScanUtils.empty(user.getCompany8x()) || user.getTeams8x() == null || user.getTeams8x().isEmpty() || user.getType8x() == null || user.getRole8x() == null) {
            throw new CheckmarxLegacyException("Missing team, type, or company details from user details");
        }
        if (user.getType8x().equals((Object)CxUserTypes.LDAP) && ScanUtils.empty(user.getUpn())) {
            throw new CheckmarxLegacyException("Missing upn, which is required for LDAP user");
        }
        if (user.getType8x().equals((Object)CxUserTypes.SAML)) {
            String username = user.getUserName();
            if (username.startsWith("SAML\\")) {
                username = username.replace("SAML\\", "SAML#");
            }
            if (!username.startsWith("SAML#")) {
                username = "SAML#".concat(username);
            }
            user.setUserName(username);
        }
        AddNewUser request = new AddNewUser();
        request.setSessionID(session);
        UserData userData = new UserData();
        userData.setIsActive(user.getActive());
        userData.setAuditUser(user.isAuditor());
        userData.setUserPreferedLanguageLCID(user.getLanguageLCID());
        userData.setEmail(user.getEmail());
        userData.setUserName(user.getUserName());
        userData.setFirstName(user.getFirstName());
        userData.setLastName(user.getLastName());
        if (!ScanUtils.empty(user.getPassword())) {
            userData.setPassword(user.getPassword());
        }
        userData.setWillExpireAfterDays(user.getExpirationDays().toString());
        if (!ScanUtils.empty(user.getUpn())) {
            userData.setUPN(user.getUpn());
        }
        if (ScanUtils.empty(user.getCompanyId8x())) {
            user.setCompanyId8x(this.getCompany(session, user.getCompany8x()));
        }
        CxWSRoleWithUserPrivileges role = new CxWSRoleWithUserPrivileges();
        role.setName(user.getRole8x().getKey());
        role.setID(user.getRole8x().getValue().toString());
        userData.setRoleData(role);
        ArrayOfGroup arrayOfGroup = new ArrayOfGroup();
        List<Group> groups = arrayOfGroup.getGroup();
        for (Map.Entry<String, String> entry : user.getTeams8x().entrySet()) {
            Group group = new Group();
            group.setGroupName(entry.getValue());
            group.setID(entry.getKey());
            group.setGuid(entry.getKey());
            group.setType(GroupType.TEAM);
            groups.add(group);
        }
        userData.setGroupList(arrayOfGroup);
        userData.setCompanyID(user.getCompanyId8x());
        userData.setCompanyName(user.getCompany8x());
        request.setUserData(userData);
        request.setUserType(user.getType8x());
        AddNewUserResponse response = (AddNewUserResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_ADD_USER));
        if (!response.getAddNewUserResult().isIsSuccesfull()) {
            log.error(response.getAddNewUserResult().getErrorMessage());
            throw new CheckmarxLegacyException("Error occurred while creating user: " + response.getAddNewUserResult().getErrorMessage());
        }
    }

    public void updateUser(String session, CxUser user) throws CheckmarxLegacyException {
        if (ScanUtils.empty(user.getCompany8x()) || ScanUtils.empty(user.getCompanyId8x()) || user.getTeams8x() == null || user.getTeams8x().isEmpty() || user.getRole8x() == null) {
            throw new CheckmarxLegacyException("Missing team, type, or company details from user details");
        }
        UpdateUserData request = new UpdateUserData();
        request.setSessionID(session);
        UserData userData = new UserData();
        userData.setID(user.getId());
        userData.setIsActive(user.getActive());
        userData.setAuditUser(user.isAuditor());
        userData.setUserPreferedLanguageLCID(user.getLanguageLCID());
        userData.setEmail(user.getEmail());
        if (!ScanUtils.empty(user.getPassword())) {
            userData.setPassword(user.getPassword());
        }
        userData.setFirstName(user.getFirstName());
        userData.setLastName(user.getLastName());
        if (!ScanUtils.empty(user.getPassword())) {
            userData.setPassword(user.getPassword());
        }
        if (user.getExpirationDays() != null && user.getExpirationDays() > 0) {
            userData.setWillExpireAfterDays(user.getExpirationDays().toString());
        }
        CxWSRoleWithUserPrivileges role = new CxWSRoleWithUserPrivileges();
        role.setName(user.getRole8x().getKey());
        role.setID(user.getRole8x().getValue().toString());
        userData.setRoleData(role);
        ArrayOfGroup arrayOfGroup = new ArrayOfGroup();
        List<Group> groups = arrayOfGroup.getGroup();
        for (Map.Entry<String, String> entry : user.getTeams8x().entrySet()) {
            Group group = new Group();
            group.setGroupName(entry.getValue());
            group.setID(entry.getKey());
            group.setGuid(entry.getKey());
            group.setType(GroupType.TEAM);
            groups.add(group);
        }
        userData.setGroupList(arrayOfGroup);
        userData.setCompanyID(user.getCompanyId8x());
        userData.setCompanyName(user.getCompany8x());
        request.setUserData(userData);
        UpdateUserDataResponse response = (UpdateUserDataResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_UPDATE_USER));
        if (!response.getUpdateUserDataResult().isIsSuccesfull()) {
            log.error(response.getUpdateUserDataResult().getErrorMessage());
            throw new CheckmarxLegacyException("Error occurred while updating user: " + response.getUpdateUserDataResult().getErrorMessage());
        }
    }

    public void deleteUser(String session, Integer userId) throws CheckmarxLegacyException {
        DeleteUser request = new DeleteUser();
        request.setSessionID(session);
        request.setUserID(userId);
        DeleteUserResponse response = (DeleteUserResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_GET_USER));
        if (!response.getDeleteUserResult().isIsSuccesfull()) {
            throw new CheckmarxLegacyException("Error deleting user with Id: " + response.getDeleteUserResult().getErrorMessage());
        }
    }

    void createTeam(String sessionId, String parentId, String teamName) throws CheckmarxException {
        CreateNewTeam request = new CreateNewTeam(sessionId);
        request.setNewTeamName(teamName);
        request.setParentTeamID(parentId);
        log.info("Creating team {} ({})", (Object)teamName, (Object)parentId);
        try {
            CreateNewTeamResponse response = (CreateNewTeamResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_CREATE_TEAM_URI));
            if (!response.getCreateNewTeamResult().isIsSuccesfull()) {
                log.error("Error occurred while creating Team {} with parentId {}", (Object)teamName, (Object)parentId);
                throw new CheckmarxException("Error occurred during team creation");
            }
        }
        catch (NullPointerException e) {
            log.error("Error occurred while creating Team {} with parentId {}", (Object)teamName, (Object)parentId);
            throw new CheckmarxException("Error occurred during team creation");
        }
    }

    void deleteTeam(String sessionId, String teamId) throws CheckmarxException {
        DeleteTeam request = new DeleteTeam();
        request.setSessionID(sessionId);
        request.setTeamID(teamId);
        log.info("Deleting team id {}", (Object)teamId);
        try {
            DeleteTeamResponse response = (DeleteTeamResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_DELETE_TEAM_URI));
            if (!response.getDeleteTeamResult().isIsSuccesfull()) {
                log.error("Error occurred while deleting Team id {}", (Object)teamId);
                throw new CheckmarxException("Error occurred during team deletion");
            }
        }
        catch (NullPointerException e) {
            log.error("Error occurred while deleting Team id {}", (Object)teamId);
            throw new CheckmarxException("Error occurred during team deletion");
        }
    }

    void moveTeam(String sessionId, String teamId, String newParentId) throws CheckmarxException {
        MoveTeam request = new MoveTeam();
        request.setSessionID(sessionId);
        request.setSourceID(teamId);
        request.setDestenationID(newParentId);
        log.info("Moving team {} to under {}", (Object)teamId, (Object)newParentId);
        try {
            MoveTeamResponse response = (MoveTeamResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_MOVE_TEAM_URI));
            if (!response.getMoveTeamResult().isIsSuccesfull()) {
                log.error("Error occurred while moving team {} under parentId {}", (Object)teamId, (Object)newParentId);
                throw new CheckmarxException("Error occurred during team move");
            }
        }
        catch (NullPointerException e) {
            log.error("Error occurred while moving team {} under parentId {}", (Object)teamId, (Object)newParentId);
            throw new CheckmarxException("Error occurred during team move");
        }
    }

    String getDescription(String session, Long scanId, Long pathId) {
        GetResultDescription request = new GetResultDescription(session);
        request.setPathID(pathId);
        request.setScanID(scanId);
        log.debug("Retrieving description for {} / {} ", (Object)scanId, (Object)pathId);
        GetResultDescriptionResponse response = (GetResultDescriptionResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, this.getWSCallback(CX_WS_DESCRIPTION_URI, session));
        try {
            if (!response.getGetResultDescriptionResult().isIsSuccesfull()) {
                log.error(response.getGetResultDescriptionResult().getErrorMessage());
                return "";
            }
            String description = response.getGetResultDescriptionResult().getResultDescription();
            description = description.replace(this.properties.getHtmlStrip(), "");
            description = description.replaceAll("\\<.*?>", "");
            return description;
        }
        catch (NullPointerException e) {
            log.warn("Error occurred getting description for {} / {}", (Object)scanId, (Object)pathId);
            return "";
        }
    }

    void createLdapTeamMapping(String session, Integer ldapServerId, String teamId, String teamName, String groupDn) throws CheckmarxException {
        GetTeamLdapGroupsMapping ldapReq = new GetTeamLdapGroupsMapping();
        ldapReq.setSessionId(session);
        ldapReq.setTeamId(teamId);
        log.info("Retrieving existing Ldap Group Mappings for ldap server {}", (Object)ldapServerId);
        GetTeamLdapGroupsMappingResponse ldapResponse = (GetTeamLdapGroupsMappingResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)ldapReq, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_TEAM_LDAP_MAPPINGS_URI));
        if (ldapResponse.getGetTeamLdapGroupsMappingResult().isIsSuccesfull()) {
            log.debug("Successfully retrieved ldapMappings");
            log.debug(ldapResponse.getGetTeamLdapGroupsMappingResult().getLdapGroups().getCxWSLdapGroupMapping().toString());
            CxWSLdapGroupMapping newMapping = new CxWSLdapGroupMapping();
            CxWSLdapGroup ldapGroup = new CxWSLdapGroup();
            ldapGroup.setDN(groupDn);
            String name = CxService.getNameFromLDAP(groupDn);
            ldapGroup.setName(name);
            newMapping.setLdapGroup(ldapGroup);
            newMapping.setLdapServerId(ldapServerId);
            ArrayOfCxWSLdapGroupMapping ldapArray = ldapResponse.getGetTeamLdapGroupsMappingResult().getLdapGroups();
            List<CxWSLdapGroupMapping> ldapGroupMapping = ldapArray.getCxWSLdapGroupMapping();
            if (!ldapGroupMapping.contains(newMapping)) {
                ldapGroupMapping.add(newMapping);
                this.updateTeam(session, teamId, teamName, ldapArray);
            } else {
                log.warn("Ldap mapping already exists for {} - {}", (Object)ldapServerId, (Object)groupDn);
            }
        } else {
            log.error("Error occurred while getting team ldap mapping {}", (Object)ldapResponse.getGetTeamLdapGroupsMappingResult().getErrorMessage());
            throw new CheckmarxException("Error occurred while getting team ldap mapping".concat(ldapResponse.getGetTeamLdapGroupsMappingResult().getErrorMessage()));
        }
    }

    void updateTeam(String session, String teamId, String teamName, ArrayOfCxWSLdapGroupMapping ldapArray) throws CheckmarxException {
        UpdateTeam updateTeamReq = new UpdateTeam();
        updateTeamReq.setSessionID(session);
        updateTeamReq.setLdapGroupMappings(ldapArray);
        updateTeamReq.setTeamID(teamId);
        updateTeamReq.setNewTeamName(teamName);
        UpdateTeamResponse updateTeamResponse = (UpdateTeamResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)updateTeamReq, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_UPDATE_TEAM_URI));
        if (!updateTeamResponse.getUpdateTeamResult().isIsSuccesfull()) {
            log.error("Error occurred while updating team ldap mapping {}", (Object)updateTeamResponse.getUpdateTeamResult().getErrorMessage());
            throw new CheckmarxException("Error occurred while updating team ldap mapping {}".concat(updateTeamResponse.getUpdateTeamResult().getErrorMessage()));
        }
    }

    void removeLdapTeamMapping(String session, Integer ldapServerId, String teamId, String teamName, String groupDn) throws CheckmarxException {
        GetTeamLdapGroupsMapping ldapReq = new GetTeamLdapGroupsMapping();
        ldapReq.setSessionId(session);
        ldapReq.setTeamId(teamId);
        log.info("Retrieving existing Ldap Group Mappings for ldap server {}", (Object)ldapServerId);
        GetTeamLdapGroupsMappingResponse ldapResponse = (GetTeamLdapGroupsMappingResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)ldapReq, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_TEAM_LDAP_MAPPINGS_URI));
        if (ldapResponse.getGetTeamLdapGroupsMappingResult().isIsSuccesfull()) {
            log.debug("Successfully retrieved ldapMappings");
            log.debug(ldapResponse.getGetTeamLdapGroupsMappingResult().getLdapGroups().getCxWSLdapGroupMapping().toString());
            CxWSLdapGroupMapping newMapping = new CxWSLdapGroupMapping();
            CxWSLdapGroup ldapGroup = new CxWSLdapGroup();
            ldapGroup.setDN(groupDn);
            String name = CxService.getNameFromLDAP(groupDn);
            ldapGroup.setName(name);
            newMapping.setLdapGroup(ldapGroup);
            newMapping.setLdapServerId(ldapServerId);
            ArrayOfCxWSLdapGroupMapping ldapArray = ldapResponse.getGetTeamLdapGroupsMappingResult().getLdapGroups();
            List<CxWSLdapGroupMapping> ldapGroupMapping = ldapArray.getCxWSLdapGroupMapping();
            if (ldapGroupMapping.contains(newMapping)) {
                ldapGroupMapping.remove(newMapping);
                this.updateTeam(session, teamId, teamName, ldapArray);
            } else {
                log.warn("Ldap mapping already exists for {} - {}", (Object)ldapServerId, (Object)groupDn);
            }
        } else {
            log.error("Error occurred while getting team ldap mapping {}", (Object)ldapResponse.getGetTeamLdapGroupsMappingResult().getErrorMessage());
            throw new CheckmarxException("Error occurred while getting team ldap mapping".concat(ldapResponse.getGetTeamLdapGroupsMappingResult().getErrorMessage()));
        }
    }

    Integer getLdapServerId(String session, String serverName) throws CheckmarxException {
        GetLdapServersConfigurations request = new GetLdapServersConfigurations();
        request.setSessionId(session);
        log.debug("Retrieving Ldap Server Configurations");
        GetLdapServersConfigurationsResponse response = (GetLdapServersConfigurationsResponse)this.ws.marshalSendAndReceive(this.ws.getDefaultUri(), (Object)request, (WebServiceMessageCallback)new SoapActionCallback(CX_WS_LDAP_CONFIGURATIONS_URI));
        try {
            if (!response.getGetLdapServersConfigurationsResult().isIsSuccesfull()) {
                log.error(response.getGetLdapServersConfigurationsResult().getErrorMessage());
                throw new CheckmarxException(response.getGetLdapServersConfigurationsResult().getErrorMessage());
            }
            List<CxWSLdapServerConfiguration> ldapConfigs = response.getGetLdapServersConfigurationsResult().getServerConfigs().getCxWSLdapServerConfiguration();
            for (CxWSLdapServerConfiguration ldap : ldapConfigs) {
                if (!ldap.getName().equalsIgnoreCase(serverName)) continue;
                return ldap.getId();
            }
            return -1;
        }
        catch (NullPointerException e) {
            log.warn("Error occurred getting ldap server configurations");
            throw new CheckmarxException("Error occurred while getting ldap server configurations");
        }
    }

    private WebServiceMessageCallback getWSCallback(String callbackUri, String token) {
        return message -> {
            SoapMessage soapMessage = (SoapMessage)message;
            soapMessage.setSoapAction(callbackUri);
            TransportContext context = TransportContextHolder.getTransportContext();
            HttpUrlConnection connection = (HttpUrlConnection)context.getConnection();
            try {
                if (!ScanUtils.empty(token) && this.properties.getVersion() >= 9.0) {
                    connection.addRequestHeader("Authorization", "Bearer ".concat(token));
                }
            }
            catch (IOException e) {
                log.warn("Problem adding SOAP WS http header: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        };
    }
}

